/*
 * Decompiled with CFR 0.152.
 */
package net.vvakame.memvache;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.vvakame.memvache.AggressiveQueryCacheStrategy;
import net.vvakame.memvache.GetPutCacheStrategy;
import net.vvakame.memvache.MemvacheDelegate;
import net.vvakame.memvache.QueryKeysOnlyStrategy;
import net.vvakame.memvache.RpcVisitor;

public class MemvacheFilter
implements Filter {
    static final Logger logger = Logger.getLogger(MemvacheFilter.class.getSimpleName());

    public void init(FilterConfig filterConfig) {
        boolean enableGetPutCache = true;
        boolean enableQueryKeysOnly = true;
        boolean enableAggressiveQueryCache = false;
        boolean debug = false;
        try {
            String debugMode;
            String aggressiveQueryCache;
            String queryKeysOnly;
            String getPutCache = filterConfig.getInitParameter("enableGetPutCacheStrategy");
            if (!MemvacheFilter.isEmpty(getPutCache)) {
                enableGetPutCache = Boolean.valueOf(getPutCache);
            }
            if (!MemvacheFilter.isEmpty(queryKeysOnly = filterConfig.getInitParameter("enableQueryKeysOnlyStrategy"))) {
                enableQueryKeysOnly = Boolean.valueOf(queryKeysOnly);
            }
            if (!MemvacheFilter.isEmpty(aggressiveQueryCache = filterConfig.getInitParameter("enableAggressiveQueryCacheStrategy"))) {
                enableAggressiveQueryCache = Boolean.valueOf(aggressiveQueryCache);
            }
            if (!MemvacheFilter.isEmpty(debugMode = filterConfig.getInitParameter("enableDebugMode"))) {
                debug = Boolean.valueOf(debugMode);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (enableGetPutCache) {
            MemvacheDelegate.addStrategy(GetPutCacheStrategy.class);
        } else {
            MemvacheDelegate.removeStrategy(GetPutCacheStrategy.class);
        }
        if (enableQueryKeysOnly) {
            MemvacheDelegate.addStrategy(QueryKeysOnlyStrategy.class);
        } else {
            MemvacheDelegate.removeStrategy(QueryKeysOnlyStrategy.class);
        }
        if (enableAggressiveQueryCache) {
            MemvacheDelegate.addStrategy(AggressiveQueryCacheStrategy.class);
        } else {
            MemvacheDelegate.removeStrategy(AggressiveQueryCacheStrategy.class);
        }
        RpcVisitor.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        MemvacheDelegate delegate = null;
        try {
            delegate = MemvacheDelegate.install();
            this.preProcess(delegate);
        }
        catch (Throwable th) {
            logger.log(Level.INFO, "failed to create api call log.");
        }
        finally {
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable th) {
                logger.log(Level.INFO, "failed to save accesslog.", th);
                this.doThrow(th);
            }
            finally {
                if (delegate != null) {
                    delegate.uninstall();
                }
            }
        }
    }

    protected void preProcess(MemvacheDelegate delegate) {
    }

    void doThrow(Throwable th) throws IOException, ServletException {
        if (th instanceof ServletException) {
            throw (ServletException)th;
        }
        if (th instanceof IOException) {
            throw (IOException)th;
        }
        throw new ServletException(th);
    }

    public void destroy() {
    }

    static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }
}

