/*
 * Decompiled with CFR 0.152.
 */
package net.vvakame.memvache;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslatorPublic;
import com.google.appengine.api.datastore.Key;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.vvakame.memvache.MemcacheKeyUtil;
import net.vvakame.memvache.MemvacheDelegate;
import net.vvakame.memvache.Pair;
import net.vvakame.memvache.PbKeyUtil;
import net.vvakame.memvache.RpcVisitor;

public class QueryKeysOnlyStrategy
extends RpcVisitor {
    static final int PRIORITY = 2000;
    List<DatastorePb.Query> rewritedQuery = new ArrayList<DatastorePb.Query>();
    List<DatastorePb.Cursor> rewritedCursor = new ArrayList<DatastorePb.Cursor>();

    @Override
    public int getPriority() {
        return 2000;
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_RunQuery(DatastorePb.Query requestPb) {
        if (requestPb.isKeysOnly()) {
            return null;
        }
        if (requestPb.getKind().startsWith("__")) {
            return null;
        }
        requestPb.setKeysOnly(true);
        this.rewritedQuery.add(requestPb);
        return Pair.request(requestPb.toByteArray());
    }

    @Override
    public byte[] post_datastore_v3_RunQuery(DatastorePb.Query requestPb, DatastorePb.QueryResult responsePb) {
        if (!this.rewritedQuery.contains(requestPb)) {
            return null;
        }
        if (responsePb.isMoreResults()) {
            this.rewritedCursor.add(responsePb.getCursor());
        }
        this.reconstructQueryResult(responsePb);
        return responsePb.toByteArray();
    }

    @Override
    public byte[] post_datastore_v3_Next(DatastorePb.NextRequest requestPb, DatastorePb.QueryResult responsePb) {
        if (this.rewritedCursor == null || !this.rewritedCursor.contains(requestPb.getCursor())) {
            return null;
        }
        this.reconstructQueryResult(responsePb);
        return responsePb.toByteArray();
    }

    void reconstructQueryResult(DatastorePb.QueryResult responsePb) {
        List protos = responsePb.results();
        ArrayList<OnestoreEntity.Reference> requestedKeys = new ArrayList<OnestoreEntity.Reference>();
        for (OnestoreEntity.EntityProto proto : protos) {
            requestedKeys.add(proto.getKey());
        }
        List<Key> keys = PbKeyUtil.toKeys(requestedKeys);
        Map all = MemvacheDelegate.getMemcache().getAll(keys);
        Map<Key, DatastorePb.GetResponse.Entity> cached = MemcacheKeyUtil.conv(all);
        Map batchGet = null;
        if (cached.size() != keys.size()) {
            ArrayList<Key> missingKeys = new ArrayList<Key>();
            for (Key key : keys) {
                if (cached.containsKey(key)) continue;
                missingKeys.add(key);
            }
            DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
            batchGet = datastore.get(missingKeys);
        }
        responsePb.setKeysOnly(false);
        responsePb.clearResult();
        for (Key key : keys) {
            Entity entityByGet;
            Entity entity = entityByGet = batchGet == null ? null : (Entity)batchGet.get(key);
            if (entityByGet != null) {
                OnestoreEntity.EntityProto proto = EntityTranslatorPublic.convertToPb(entityByGet);
                responsePb.addResult(proto);
                continue;
            }
            DatastorePb.GetResponse.Entity entity2 = cached.get(key);
            if (entity2 == null) continue;
            responsePb.addResult(entity2.getEntity());
        }
    }
}

