/*
 * Decompiled with CFR 0.152.
 */
package net.vvakame.memvache;

import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.DatastorePb;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.vvakame.memvache.Pair;
import net.vvakame.memvache.Strategy;

public abstract class RpcVisitor
implements Strategy {
    static final Logger logger = Logger.getLogger(RpcVisitor.class.getName());
    static boolean debug = false;

    @Override
    public final Pair<byte[], byte[]> preProcess(String service, String method, byte[] request) {
        if ("datastore_v3".equals(service) && "BeginTransaction".equals(method)) {
            DatastorePb.BeginTransactionRequest requestPb = new DatastorePb.BeginTransactionRequest();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_BeginTransaction(requestPb);
        }
        if ("datastore_v3".equals(service) && "AllocateIds".equals(method)) {
            DatastorePb.AllocateIdsRequest requestPb = new DatastorePb.AllocateIdsRequest();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_AllocateIds(requestPb);
        }
        if ("datastore_v3".equals(service) && "Put".equals(method)) {
            DatastorePb.PutRequest requestPb = new DatastorePb.PutRequest();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_Put(requestPb);
        }
        if ("datastore_v3".equals(service) && "Get".equals(method)) {
            DatastorePb.GetRequest requestPb = new DatastorePb.GetRequest();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_Get(requestPb);
        }
        if ("datastore_v3".equals(service) && "Delete".equals(method)) {
            DatastorePb.DeleteRequest requestPb = new DatastorePb.DeleteRequest();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_Delete(requestPb);
        }
        if ("datastore_v3".equals(service) && "RunQuery".equals(method)) {
            DatastorePb.Query requestPb = new DatastorePb.Query();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_RunQuery(requestPb);
        }
        if ("datastore_v3".equals(service) && "Next".equals(method)) {
            DatastorePb.NextRequest requestPb = new DatastorePb.NextRequest();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_Next(requestPb);
        }
        if ("datastore_v3".equals(service) && "Commit".equals(method)) {
            DatastorePb.Transaction requestPb = new DatastorePb.Transaction();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_Commit(requestPb);
        }
        if ("datastore_v3".equals(service) && "Rollback".equals(method)) {
            DatastorePb.Transaction requestPb = new DatastorePb.Transaction();
            requestPb.mergeFrom(request);
            return this.pre_datastore_v3_Rollback(requestPb);
        }
        if ("memcache".equals(service) && "Set".equals(method)) {
            try {
                MemcacheServicePb.MemcacheSetRequest requestPb = MemcacheServicePb.MemcacheSetRequest.parseFrom((byte[])request);
                return this.pre_memcache_Set(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if ("memcache".equals(service) && "Get".equals(method)) {
            try {
                MemcacheServicePb.MemcacheGetRequest requestPb = MemcacheServicePb.MemcacheGetRequest.parseFrom((byte[])request);
                return this.pre_memcache_Get(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if ("memcache".equals(service) && "Delete".equals(method)) {
            try {
                MemcacheServicePb.MemcacheDeleteRequest requestPb = MemcacheServicePb.MemcacheDeleteRequest.parseFrom((byte[])request);
                return this.pre_memcache_Delete(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if ("memcache".equals(service) && "FlushAll".equals(method)) {
            try {
                MemcacheServicePb.MemcacheFlushRequest requestPb = MemcacheServicePb.MemcacheFlushRequest.parseFrom((byte[])request);
                return this.pre_memcache_FlushAll(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if ("memcache".equals(service) && "BatchIncrement".equals(method)) {
            try {
                MemcacheServicePb.MemcacheBatchIncrementRequest requestPb = MemcacheServicePb.MemcacheBatchIncrementRequest.parseFrom((byte[])request);
                return this.pre_memcache_BatchIncrement(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if ("memcache".equals(service) && "Increment".equals(method)) {
            try {
                MemcacheServicePb.MemcacheIncrementRequest requestPb = MemcacheServicePb.MemcacheIncrementRequest.parseFrom((byte[])request);
                return this.pre_memcache_Increment(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if ("memcache".equals(service) && "Stats".equals(method)) {
            try {
                MemcacheServicePb.MemcacheStatsRequest requestPb = MemcacheServicePb.MemcacheStatsRequest.parseFrom((byte[])request);
                return this.pre_memcache_Stats(requestPb);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("raise exception at " + service + ", " + method, e);
            }
        }
        if (debug) {
            logger.info("unknown service=" + service + ", method=" + method);
        }
        return null;
    }

    @Override
    public final byte[] postProcess(String service, String method, byte[] request, byte[] response) {
        if ("datastore_v3".equals(service) && "BeginTransaction".equals(method)) {
            DatastorePb.BeginTransactionRequest requestPb = new DatastorePb.BeginTransactionRequest();
            requestPb.mergeFrom(request);
            DatastorePb.Transaction responsePb = new DatastorePb.Transaction();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_BeginTransaction(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "AllocateIds".equals(method)) {
            DatastorePb.AllocateIdsRequest requestPb = new DatastorePb.AllocateIdsRequest();
            requestPb.mergeFrom(request);
            DatastorePb.AllocateIdsResponse responsePb = new DatastorePb.AllocateIdsResponse();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_AllocateIds(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "Put".equals(method)) {
            DatastorePb.PutRequest requestPb = new DatastorePb.PutRequest();
            requestPb.mergeFrom(request);
            DatastorePb.PutResponse responsePb = new DatastorePb.PutResponse();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_Put(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "Get".equals(method)) {
            DatastorePb.GetRequest requestPb = new DatastorePb.GetRequest();
            requestPb.mergeFrom(request);
            DatastorePb.GetResponse responsePb = new DatastorePb.GetResponse();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_Get(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "Delete".equals(method)) {
            DatastorePb.DeleteRequest requestPb = new DatastorePb.DeleteRequest();
            requestPb.mergeFrom(request);
            DatastorePb.DeleteResponse responsePb = new DatastorePb.DeleteResponse();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_Delete(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "RunQuery".equals(method)) {
            DatastorePb.Query requestPb = new DatastorePb.Query();
            requestPb.mergeFrom(request);
            DatastorePb.QueryResult responsePb = new DatastorePb.QueryResult();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_RunQuery(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "Next".equals(method)) {
            DatastorePb.NextRequest requestPb = new DatastorePb.NextRequest();
            requestPb.mergeFrom(request);
            DatastorePb.QueryResult responsePb = new DatastorePb.QueryResult();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_Next(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "Commit".equals(method)) {
            DatastorePb.Transaction requestPb = new DatastorePb.Transaction();
            requestPb.mergeFrom(request);
            DatastorePb.CommitResponse responsePb = new DatastorePb.CommitResponse();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_Commit(requestPb, responsePb);
        }
        if ("datastore_v3".equals(service) && "Rollback".equals(method)) {
            DatastorePb.Transaction requestPb = new DatastorePb.Transaction();
            requestPb.mergeFrom(request);
            DatastorePb.CommitResponse responsePb = new DatastorePb.CommitResponse();
            responsePb.mergeFrom(response);
            return this.post_datastore_v3_Rollback(requestPb, responsePb);
        }
        if ("memcache".equals(service) && "Set".equals(method)) {
            try {
                MemcacheServicePb.MemcacheSetRequest requestPb = MemcacheServicePb.MemcacheSetRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheSetResponse responsePb = MemcacheServicePb.MemcacheSetResponse.parseFrom((byte[])response);
                return this.post_memcache_Set(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if ("memcache".equals(service) && "Get".equals(method)) {
            try {
                MemcacheServicePb.MemcacheGetRequest requestPb = MemcacheServicePb.MemcacheGetRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheGetResponse responsePb = MemcacheServicePb.MemcacheGetResponse.parseFrom((byte[])response);
                return this.post_memcache_Get(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if ("memcache".equals(service) && "Delete".equals(method)) {
            try {
                MemcacheServicePb.MemcacheDeleteRequest requestPb = MemcacheServicePb.MemcacheDeleteRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheDeleteResponse responsePb = MemcacheServicePb.MemcacheDeleteResponse.parseFrom((byte[])response);
                return this.post_memcache_Delete(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if ("memcache".equals(service) && "FlushAll".equals(method)) {
            try {
                MemcacheServicePb.MemcacheFlushRequest requestPb = MemcacheServicePb.MemcacheFlushRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheFlushResponse responsePb = MemcacheServicePb.MemcacheFlushResponse.parseFrom((byte[])response);
                return this.post_memcache_FlushAll(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if ("memcache".equals(service) && "BatchIncrement".equals(method)) {
            try {
                MemcacheServicePb.MemcacheBatchIncrementRequest requestPb = MemcacheServicePb.MemcacheBatchIncrementRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheBatchIncrementResponse responsePb = MemcacheServicePb.MemcacheBatchIncrementResponse.parseFrom((byte[])response);
                return this.post_memcache_BatchIncrement(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if ("memcache".equals(service) && "Increment".equals(method)) {
            try {
                MemcacheServicePb.MemcacheIncrementRequest requestPb = MemcacheServicePb.MemcacheIncrementRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheIncrementResponse responsePb = MemcacheServicePb.MemcacheIncrementResponse.parseFrom((byte[])response);
                return this.post_memcache_Increment(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if ("memcache".equals(service) && "Stats".equals(method)) {
            try {
                MemcacheServicePb.MemcacheStatsRequest requestPb = MemcacheServicePb.MemcacheStatsRequest.parseFrom((byte[])request);
                MemcacheServicePb.MemcacheSetResponse responsePb = MemcacheServicePb.MemcacheSetResponse.parseFrom((byte[])response);
                return this.post_memcache_Stats(requestPb, responsePb);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "raise exception at " + service + ", " + method, e);
            }
        } else if (debug) {
            logger.info("unknown service=" + service + ", method=" + method);
        }
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_BeginTransaction(DatastorePb.BeginTransactionRequest requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_BeginTransaction(DatastorePb.BeginTransactionRequest requestPb, DatastorePb.Transaction responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_AllocateIds(DatastorePb.AllocateIdsRequest requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_AllocateIds(DatastorePb.AllocateIdsRequest requestPb, DatastorePb.AllocateIdsResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_Put(DatastorePb.PutRequest requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_Put(DatastorePb.PutRequest requestPb, DatastorePb.PutResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_Get(DatastorePb.GetRequest requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_Get(DatastorePb.GetRequest requestPb, DatastorePb.GetResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_Delete(DatastorePb.DeleteRequest requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_Delete(DatastorePb.DeleteRequest requestPb, DatastorePb.DeleteResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_RunQuery(DatastorePb.Query requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_RunQuery(DatastorePb.Query requestPb, DatastorePb.QueryResult responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_Next(DatastorePb.NextRequest requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_Next(DatastorePb.NextRequest requestPb, DatastorePb.QueryResult responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_Commit(DatastorePb.Transaction requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_Commit(DatastorePb.Transaction requestPb, DatastorePb.CommitResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_datastore_v3_Rollback(DatastorePb.Transaction requestPb) {
        return null;
    }

    public byte[] post_datastore_v3_Rollback(DatastorePb.Transaction requestPb, DatastorePb.CommitResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_Set(MemcacheServicePb.MemcacheSetRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_Set(MemcacheServicePb.MemcacheSetRequest requestPb, MemcacheServicePb.MemcacheSetResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_Get(MemcacheServicePb.MemcacheGetRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_Get(MemcacheServicePb.MemcacheGetRequest requestPb, MemcacheServicePb.MemcacheGetResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_Delete(MemcacheServicePb.MemcacheDeleteRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_Delete(MemcacheServicePb.MemcacheDeleteRequest requestPb, MemcacheServicePb.MemcacheDeleteResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_FlushAll(MemcacheServicePb.MemcacheFlushRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_FlushAll(MemcacheServicePb.MemcacheFlushRequest requestPb, MemcacheServicePb.MemcacheFlushResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_BatchIncrement(MemcacheServicePb.MemcacheBatchIncrementRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_BatchIncrement(MemcacheServicePb.MemcacheBatchIncrementRequest requestPb, MemcacheServicePb.MemcacheBatchIncrementResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_Increment(MemcacheServicePb.MemcacheIncrementRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_Increment(MemcacheServicePb.MemcacheIncrementRequest requestPb, MemcacheServicePb.MemcacheIncrementResponse responsePb) {
        return null;
    }

    public Pair<byte[], byte[]> pre_memcache_Stats(MemcacheServicePb.MemcacheStatsRequest requestPb) {
        return null;
    }

    public byte[] post_memcache_Stats(MemcacheServicePb.MemcacheStatsRequest requestPb, MemcacheServicePb.MemcacheSetResponse responsePb) {
        return null;
    }
}

