/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.plugins.util;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.common.plugins.util.PluginExecutionException;
import net.wasdev.wlp.common.plugins.util.PluginScenarioException;
import org.apache.commons.io.FileUtils;

public abstract class DevUtil {
    private static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    private static final String UPDATED_APP_MESSAGE_REGEXP = "CWWKZ0003I.*";
    private File serverDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File configDirectory;
    private List<File> resourceDirs;
    private boolean hotTests;
    private Path tempConfigPath;
    private boolean skipTests;
    private boolean skipUTs;
    private boolean skipITs;
    private String applicationId;
    private int appUpdateTimeout;
    private HotkeyReader hotkeyReader = null;

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract List<String> getArtifacts();

    public abstract boolean recompileBuildFile(File var1, List<String> var2, ThreadPoolExecutor var3);

    public abstract void runUnitTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void runIntegrationTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void checkConfigFile(File var1, File var2);

    public abstract boolean compile(File var1);

    public abstract void stopServer();

    public abstract ServerTask getDebugServerTask() throws IOException;

    public DevUtil(File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, List<File> resourceDirs, boolean hotTests, boolean skipTests, boolean skipUTs, boolean skipITs, String applicationId, int appUpdateTimeout) {
        this.serverDirectory = serverDirectory;
        this.sourceDirectory = sourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.configDirectory = configDirectory;
        this.resourceDirs = resourceDirs;
        this.hotTests = hotTests;
        this.skipTests = skipTests;
        this.skipUTs = skipUTs;
        this.skipITs = skipITs;
        this.applicationId = applicationId;
        this.appUpdateTimeout = appUpdateTimeout;
    }

    public void runTests(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs) {
        if (!this.skipTests) {
            ServerTask serverTask = null;
            try {
                serverTask = this.getDebugServerTask();
            }
            catch (IOException e) {
                this.error("Could not get the server task for running tests.", e);
            }
            File logFile = serverTask.getLogFile();
            String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.debug("Thread interrupted while waiting to start unit tests.", e);
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.debug("Tests were re-invoked before previous tests began. Cancelling previous tests and resubmitting them.");
                } else {
                    this.debug("Changes were detected before tests began. Cancelling tests and resubmitting them.");
                }
                return;
            }
            if (!this.skipUTs && !forceSkipUTs) {
                this.info("Running unit tests...");
                try {
                    this.runUnitTests();
                    this.info("Unit tests finished.");
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.info("Tests were invoked while previous tests were running. Restarting tests.");
                } else {
                    this.info("Changes were detected while tests were running. Restarting tests.");
                }
                return;
            }
            if (!this.skipITs) {
                if (waitForApplicationUpdate) {
                    if (this.appUpdateTimeout < 0) {
                        this.appUpdateTimeout = 5;
                    }
                    long timeout = this.appUpdateTimeout * 1000;
                    serverTask.waitForUpdatedStringInLog(regexp, timeout, logFile, messageOccurrences);
                }
                this.info("Running integration tests...");
                try {
                    this.runIntegrationTests();
                    this.info("Integration tests finished.");
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
        }
        this.runHotkeyReaderThread(executor);
    }

    public int countApplicationUpdatedMessages() {
        int messageOccurrences = -1;
        if (!this.skipTests && !this.skipITs) {
            try {
                ServerTask serverTask = this.getDebugServerTask();
                File logFile = serverTask.getLogFile();
                String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
                messageOccurrences = serverTask.countStringOccurrencesInFile(regexp, logFile);
                this.debug("Message occurrences before compile: " + messageOccurrences);
            }
            catch (Exception e) {
                this.debug("Failed to get message occurrences before compile", e);
            }
        }
        return messageOccurrences;
    }

    public void startServer(long serverStartTimeout, long verifyTimeout) throws PluginExecutionException {
        try {
            final ServerTask serverTask = this.getDebugServerTask();
            String logsDirectory = serverTask.getOutputDir() + "/" + serverTask.getServerName() + "/logs";
            File messagesLogFile = new File(logsDirectory + "/messages.log");
            if (serverStartTimeout < 0L) {
                serverStartTimeout = 30L;
            }
            serverTask.setTimeout(Long.toString(serverStartTimeout * 1000L));
            WatchService watchService = FileSystems.getDefault().newWatchService();
            boolean logsExist = new File(logsDirectory).isDirectory();
            if (logsExist) {
                Paths.get(logsDirectory, new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            Thread serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        serverTask.execute();
                    }
                    catch (Exception e) {
                        DevUtil.this.debug("Error starting server", e);
                    }
                }
            });
            serverThread.start();
            if (logsExist) {
                WatchKey key;
                boolean messagesModified = false;
                while (!messagesModified && (key = watchService.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!event.context().toString().equals("messages.log")) continue;
                        messagesModified = true;
                        this.debug("messages.log has been changed");
                    }
                    if (key.reset()) continue;
                }
            }
            if (verifyTimeout < 0L) {
                verifyTimeout = 30L;
            }
            long timeout = verifyTimeout * 1000L;
            long endTime = System.currentTimeMillis() + timeout;
            String startMessage = serverTask.waitForStringInLog(START_APP_MESSAGE_REGEXP, timeout, messagesLogFile);
            if (startMessage == null) {
                this.stopServer();
                throw new PluginExecutionException("Unable to verify if the server was started after " + verifyTimeout + " seconds.");
            }
            timeout = endTime - System.currentTimeMillis();
        }
        catch (Exception e) {
            this.debug("Error starting server", e);
        }
    }

    public void cleanUpServerEnv() {
        block5: {
            try {
                File serverEnvBackup = new File(this.serverDirectory.getCanonicalPath() + "/server.env.bak");
                File serverEnvFile = new File(this.serverDirectory.getCanonicalPath() + "/server.env");
                if (serverEnvBackup.exists()) {
                    try {
                        Files.copy(serverEnvBackup.toPath(), serverEnvFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.error("Could not restore server.env: " + e.getMessage());
                    }
                    serverEnvBackup.delete();
                    break block5;
                }
                serverEnvFile.delete();
            }
            catch (IOException e) {
                this.error("Could not retrieve server.env: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempConfig() {
        File tempConfig;
        if (this.tempConfigPath != null && (tempConfig = this.tempConfigPath.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)tempConfig);
                this.debug("Sucessfully deleted liberty:dev temporary configuration folder");
            }
            catch (IOException e) {
                this.error("Could not delete liberty:dev temporary configuration folder");
            }
        }
    }

    public void addShutdownHook(final ThreadPoolExecutor executor) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DevUtil.this.debug("Inside Shutdown Hook, shutting down server");
                DevUtil.this.cleanUpTempConfig();
                DevUtil.this.cleanUpServerEnv();
                if (DevUtil.this.hotkeyReader != null) {
                    DevUtil.this.hotkeyReader.shutdown();
                }
                executor.shutdown();
                DevUtil.this.stopServer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableServerDebug(int libertyDebugPort) throws IOException {
        String serverEnvPath = this.serverDirectory.getCanonicalPath() + "/server.env";
        File serverEnvFile = new File(serverEnvPath);
        StringBuilder sb = new StringBuilder();
        if (serverEnvFile.exists()) {
            this.debug("server.env already exists");
            File serverEnvBackup = new File(serverEnvPath + ".bak");
            Files.copy(serverEnvFile.toPath(), serverEnvBackup.toPath(), new CopyOption[0]);
            boolean deleted = serverEnvFile.delete();
            if (!deleted) {
                this.error("Could not move existing liberty:dev server.env file");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(serverEnvBackup));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
        }
        this.debug("Creating server.env file: " + serverEnvFile.getCanonicalPath());
        sb.append("WLP_DEBUG_SUSPEND=n\n");
        sb.append("WLP_DEBUG_ADDRESS=");
        sb.append(libertyDebugPort);
        sb.append("\n");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(serverEnvFile));){
            writer.write(sb.toString());
        }
        if (serverEnvFile.exists()) {
            this.info("Successfully created liberty:dev server.env file");
        }
    }

    public void runHotkeyReaderThread(ThreadPoolExecutor executor) {
        if (this.hotkeyReader == null) {
            this.hotkeyReader = new HotkeyReader(executor);
            new Thread(this.hotkeyReader).start();
            this.debug("Started hotkey reader.");
            if (!this.skipTests) {
                if (this.hotTests) {
                    this.info("Tests will run automatically when changes are detected. You can also press the Enter key to run tests on demand.");
                } else {
                    this.info("Press the Enter key to run tests on demand.");
                }
            }
        }
    }

    public void watchFiles(File buildFile, File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, List<String> artifactPaths, File configFile) throws Exception {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Throwable throwable = null;
        try {
            try {
                File serverXML = this.getFileFromConfigDirectory("server.xml");
                File configFileParent = configFile.getParentFile();
                Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
                Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
                Path configPath = this.configDirectory.getCanonicalFile().toPath();
                boolean sourceDirRegistered = false;
                boolean testSourceDirRegistered = false;
                boolean configDirRegistered = false;
                boolean configFileRegistered = false;
                if (this.sourceDirectory.exists()) {
                    this.registerAll(srcPath, watcher);
                    sourceDirRegistered = true;
                }
                if (this.testSourceDirectory.exists()) {
                    this.registerAll(testSrcPath, watcher);
                    testSourceDirRegistered = true;
                }
                if (this.configDirectory.exists()) {
                    this.registerAll(configPath, watcher);
                    configDirRegistered = true;
                }
                if (configFile.exists() && configFileParent.exists()) {
                    Path configFilePath = configFileParent.getCanonicalFile().toPath();
                    this.registerAll(configFilePath, watcher);
                    configFileRegistered = true;
                }
                HashMap<File, Boolean> resourceMap = new HashMap<File, Boolean>();
                for (File resourceDir : this.resourceDirs) {
                    resourceMap.put(resourceDir, false);
                    if (!resourceDir.exists()) continue;
                    this.registerAll(resourceDir.getCanonicalFile().toPath(), watcher);
                    resourceMap.put(resourceDir, true);
                }
                buildFile.getParentFile().toPath().register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                this.debug("Watching build file directory: " + buildFile.getParentFile().toPath());
                while (true) {
                    if (!sourceDirRegistered && this.sourceDirectory.exists() && this.sourceDirectory.listFiles().length > 0) {
                        this.compile(this.sourceDirectory);
                        this.registerAll(srcPath, watcher);
                        this.debug("Registering Java source directory: " + this.sourceDirectory);
                        sourceDirRegistered = true;
                    } else if (sourceDirRegistered && !this.sourceDirectory.exists()) {
                        this.cleanTargetDir(outputDirectory);
                        sourceDirRegistered = false;
                    }
                    if (!testSourceDirRegistered && this.testSourceDirectory.exists() && this.testSourceDirectory.listFiles().length > 0) {
                        this.compile(this.testSourceDirectory);
                        this.registerAll(testSrcPath, watcher);
                        this.debug("Registering Java test directory: " + this.testSourceDirectory);
                        this.runTestThread(false, executor, -1, false, false);
                        testSourceDirRegistered = true;
                    } else if (testSourceDirRegistered && !this.testSourceDirectory.exists()) {
                        this.cleanTargetDir(testOutputDirectory);
                        testSourceDirRegistered = false;
                    }
                    if (!configDirRegistered && this.configDirectory.exists()) {
                        configDirRegistered = true;
                        this.debug("Configuration directory has been added: " + this.configDirectory);
                        this.info("The server configuration directory " + this.configDirectory + " has been added. Restart liberty:dev mode for it to take effect.");
                    }
                    if (!configFileRegistered && configFile.exists()) {
                        configFileRegistered = true;
                        this.debug("Configuration file has been added: " + configFile);
                        this.info("The server configuration file " + configFile + " has been added. Restart liberty:dev mode for it to take effect.");
                    }
                    for (File resourceDir : this.resourceDirs) {
                        if (((Boolean)resourceMap.get(resourceDir)).booleanValue() || !resourceDir.exists()) continue;
                        resourceMap.put(resourceDir, true);
                        this.debug("Resource directory has been added: " + resourceDir);
                        this.info("The resource directory " + resourceDir + "has been added. Restart liberty:dev mode for it to take effect.");
                    }
                    try {
                        WatchKey wk = watcher.poll(1L, TimeUnit.SECONDS);
                        for (WatchEvent<?> event : wk.pollEvents()) {
                            boolean recompiledBuild;
                            ArrayList<File> javaFilesChanged;
                            Path changed = (Path)event.context();
                            Watchable watchable = wk.watchable();
                            Path directory = (Path)watchable;
                            this.debug("Processing events for watched directory: " + directory);
                            File fileChanged = new File(directory.toString(), changed.toString());
                            this.debug("Changed: " + changed + "; " + event.kind());
                            File resourceParent = null;
                            for (File resourceDir : this.resourceDirs) {
                                if (!directory.startsWith(resourceDir.getCanonicalFile().toPath())) continue;
                                resourceParent = resourceDir;
                                break;
                            }
                            int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                            if (directory.startsWith(srcPath)) {
                                javaFilesChanged = new ArrayList<File>();
                                javaFilesChanged.add(fileChanged);
                                if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.debug("Java source file modified: " + fileChanged.getName());
                                    this.recompileJavaSource(javaFilesChanged, artifactPaths, executor, outputDirectory, testOutputDirectory);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.debug("Java file deleted: " + fileChanged.getName());
                                this.deleteJavaFile(fileChanged, outputDirectory, this.sourceDirectory);
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                                continue;
                            }
                            if (directory.startsWith(testSrcPath)) {
                                javaFilesChanged = new ArrayList();
                                javaFilesChanged.add(fileChanged);
                                if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.recompileJavaTest(javaFilesChanged, artifactPaths, executor, outputDirectory, testOutputDirectory);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.debug("Java file deleted: " + fileChanged.getName());
                                this.deleteJavaFile(fileChanged, testOutputDirectory, this.testSourceDirectory);
                                this.runTestThread(false, executor, -1, false, false);
                                continue;
                            }
                            if (directory.startsWith(configPath)) {
                                if (fileChanged.exists() && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.copyConfigFolder(fileChanged, this.configDirectory, "server.xml");
                                    this.copyFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                                    this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.info("Config file deleted: " + fileChanged.getName());
                                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                continue;
                            }
                            if (directory.startsWith(configFileParent.getCanonicalFile().toPath())) {
                                if (serverXML != null && serverXML.exists()) continue;
                                if (fileChanged.exists() && fileChanged.getCanonicalPath().endsWith(configFile.getName()) && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.copyConfigFolder(fileChanged, configFileParent, "server.xml");
                                    this.copyFile(fileChanged, configFileParent, this.serverDirectory, "server.xml");
                                    this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE || !fileChanged.getCanonicalPath().endsWith(configFile.getName())) continue;
                                this.info("Config file deleted: " + fileChanged.getName());
                                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, "server.xml");
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                continue;
                            }
                            if (resourceParent != null && directory.startsWith(resourceParent.getCanonicalFile().toPath())) {
                                this.debug("Resource dir: " + resourceParent.toString());
                                this.debug("File within resource directory");
                                if (fileChanged.exists() && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.copyFile(fileChanged, resourceParent, outputDirectory, null);
                                    this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.debug("Resource file deleted: " + fileChanged.getName());
                                this.deleteFile(fileChanged, resourceParent, outputDirectory, null);
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                                continue;
                            }
                            if (!fileChanged.equals(buildFile) || !directory.startsWith(buildFile.getParentFile().getCanonicalFile().toPath()) || event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !(recompiledBuild = this.recompileBuildFile(buildFile, artifactPaths, executor))) continue;
                            this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                        }
                        boolean valid = wk.reset();
                        if (valid) continue;
                        this.debug("WatchService key has been unregistered");
                    }
                    catch (InterruptedException | NullPointerException exception) {}
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (watcher != null) {
                if (throwable != null) {
                    try {
                        watcher.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    watcher.close();
                }
            }
            throw throwable3;
        }
    }

    public String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public void copyConfigFolder(File fileChanged, File srcDir, String targetFileName) throws IOException {
        this.tempConfigPath = Files.createTempDirectory("tempConfig", new FileAttribute[0]);
        File tempConfig = this.tempConfigPath.toFile();
        this.debug("Temporary configuration folder created: " + tempConfig);
        FileUtils.copyDirectory((File)this.serverDirectory, (File)tempConfig);
        this.copyFile(fileChanged, srcDir, tempConfig, targetFileName);
        this.checkConfigFile(fileChanged, tempConfig);
        this.cleanUpTempConfig();
    }

    public void copyFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        String relPath = fileChanged.getCanonicalPath().substring(fileChanged.getCanonicalPath().indexOf(srcDir.getCanonicalPath()) + srcDir.getCanonicalPath().length());
        if (targetFileName != null) {
            relPath = relPath.substring(0, relPath.indexOf(fileChanged.getName())) + targetFileName;
        }
        File targetResource = new File(targetDir.getCanonicalPath() + relPath);
        try {
            FileUtils.copyFile((File)fileChanged, (File)targetResource);
            this.info("Copied file: " + fileChanged.getCanonicalPath() + " to: " + targetResource.getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            this.debug("Failed to copy file: " + fileChanged.getCanonicalPath());
        }
        catch (Exception ex) {
            this.debug(ex);
        }
    }

    protected void deleteFile(File deletedFile, File dir, File targetDir, String targetFileName) throws IOException {
        this.debug("File that was deleted: " + deletedFile.getCanonicalPath());
        String relPath = deletedFile.getCanonicalPath().substring(deletedFile.getCanonicalPath().indexOf(dir.getCanonicalPath()) + dir.getCanonicalPath().length());
        if (targetFileName != null) {
            relPath = relPath.substring(0, relPath.indexOf(deletedFile.getName())) + targetFileName;
        }
        File targetFile = new File(targetDir.getCanonicalPath() + relPath);
        this.debug("Target file exists: " + targetFile.exists());
        if (targetFile.exists()) {
            if (targetFile.delete()) {
                this.info("Deleted file" + targetFile.getCanonicalPath());
            } else {
                this.error("Error deleting file " + targetFile.getCanonicalPath());
            }
        }
    }

    protected void cleanTargetDir(File outputDirectory) {
        File[] fList = outputDirectory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                    file.delete();
                    this.info("Deleted Java class file: " + file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.cleanTargetDir(file);
            }
        }
        if (outputDirectory.listFiles().length == 0) {
            outputDirectory.delete();
        }
    }

    protected void registerAll(Path start, final WatchService watcher) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                DevUtil.this.debug("Watching directory: " + dir.toString());
                dir.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected File getFileFromConfigDirectory(String file) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    protected void deleteJavaFile(File fileChanged, File classesDir, File compileSourceRoot) throws IOException {
        if (fileChanged.getName().endsWith(".java")) {
            String fileName = fileChanged.getName().substring(0, fileChanged.getName().indexOf(".java"));
            File parentFile = fileChanged.getParentFile();
            String relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName + ".class";
            File targetFile = new File(classesDir.getCanonicalPath() + relPath);
            if (targetFile.exists()) {
                targetFile.delete();
                this.info("Java class deleted: " + targetFile.getCanonicalPath());
            }
        } else {
            this.debug("File deleted but was not a java file: " + fileChanged.getName());
        }
    }

    protected void recompileJavaSource(List<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws Exception {
        this.recompileJava(javaFilesChanged, artifactPaths, executor, false, outputDirectory, testOutputDirectory);
    }

    protected void recompileJavaTest(List<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws Exception {
        this.recompileJava(javaFilesChanged, artifactPaths, executor, true, outputDirectory, testOutputDirectory);
    }

    protected void recompileJava(List<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, boolean tests, File outputDirectory, File testOutputDirectory) {
        try {
            int messageOccurrences = this.countApplicationUpdatedMessages();
            File classesDir = tests ? testOutputDirectory : outputDirectory;
            ArrayList<String> optionList = new ArrayList<String>();
            ArrayList<File> outputDirs = new ArrayList<File>();
            if (tests) {
                outputDirs.add(outputDirectory);
                outputDirs.add(testOutputDirectory);
            } else {
                outputDirs.add(outputDirectory);
            }
            Set<File> classPathElems = this.getClassPath(artifactPaths, outputDirs);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            fileManager.setLocation(StandardLocation.CLASS_PATH, classPathElems);
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(classesDir));
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(javaFilesChanged);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, optionList, null, compilationUnits);
            boolean didCompile = task.call();
            if (didCompile) {
                if (tests) {
                    this.info("Tests compilation was successful.");
                } else {
                    this.info("Source compilation was successful.");
                }
                if (tests) {
                    this.runTestThread(false, executor, -1, false, false);
                } else {
                    this.runTestThread(true, executor, messageOccurrences, false, false);
                }
            } else if (tests) {
                this.info("Tests compilation had errors.");
            } else {
                this.info("Source compilation had errors.");
            }
        }
        catch (Exception e) {
            this.debug("Error compiling java files", e);
        }
    }

    protected Set<File> getClassPath(List<String> artifactPaths, List<File> outputDirs) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader c = Thread.currentThread().getContextClassLoader(); c != null; c = c.getParent()) {
            if (!(c instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)c).getURLs()));
        }
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (URL url : urls) {
            toParse.add(new File(url.getPath()).getCanonicalPath());
        }
        for (String artifactPath : artifactPaths) {
            toParse.add(new File(artifactPath).getCanonicalPath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        classPathElements.addAll(outputDirs);
        while (!toParse.isEmpty()) {
            String s = (String)toParse.poll();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            File file = new File(s);
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            classPathElements.add(file);
            if (file.isDirectory()) continue;
            try {
                JarFile jar = new JarFile(file);
                Throwable throwable = null;
                try {
                    Object classPath;
                    Manifest mf = jar.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String i : classPath.toString().split(" ")) {
                        File f;
                        try {
                            URL u = new URL(i);
                            f = new File(u.getPath());
                        }
                        catch (MalformedURLException e) {
                            f = new File(file.getParentFile(), i);
                        }
                        if (!f.exists()) continue;
                        toParse.add(f.getCanonicalPath());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + file, e);
            }
        }
        return classPathElements;
    }

    public void runTestThread(boolean waitForApplicationUpdate, ThreadPoolExecutor executor, int messageOccurrences, boolean forceSkipUTs, boolean manualInvocation) {
        try {
            if (manualInvocation || this.hotTests) {
                executor.execute(new TestJob(waitForApplicationUpdate, messageOccurrences, executor, forceSkipUTs, manualInvocation));
            }
        }
        catch (RejectedExecutionException e) {
            this.debug("Cannot add thread since max threads reached", e);
        }
    }

    public class TestJob
    implements Runnable {
        private boolean waitForApplicationUpdate;
        private int messageOccurrences;
        private ThreadPoolExecutor executor;
        private boolean forceSkipUTs;
        private boolean manualInvocation;

        public TestJob(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs, boolean manualInvocation) {
            this.waitForApplicationUpdate = waitForApplicationUpdate;
            this.messageOccurrences = messageOccurrences;
            this.executor = executor;
            this.forceSkipUTs = forceSkipUTs;
            this.manualInvocation = manualInvocation;
        }

        @Override
        public void run() {
            DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, this.forceSkipUTs);
        }

        public boolean isManualInvocation() {
            return this.manualInvocation;
        }
    }

    private class HotkeyReader
    implements Runnable {
        private Scanner scanner;
        private ThreadPoolExecutor executor;
        private boolean shutdown = false;

        public HotkeyReader(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void run() {
            DevUtil.this.debug("Running hotkey reader thread");
            this.scanner = new Scanner(System.in);
            this.readInput();
        }

        public void shutdown() {
            this.shutdown = true;
        }

        private void readInput() {
            while (!this.shutdown) {
                DevUtil.this.debug("Waiting for Enter key to run tests");
                String line = this.scanner.nextLine();
                if (line != null && line.trim().equalsIgnoreCase("exit")) {
                    DevUtil.this.debug("Detected exit command");
                    System.exit(0);
                    continue;
                }
                DevUtil.this.debug("Detected Enter key. Running tests...");
                DevUtil.this.runTestThread(false, this.executor, -1, false, true);
            }
            DevUtil.this.debug("Hotkey reader thread was shut down");
        }
    }
}

