/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.DeployTask;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

@Mojo(name="deploy")
public class DeployAppMojo
extends BasicSupport {
    @Parameter(property="appArchive")
    protected File appArchive;
    @Parameter
    protected ArtifactItem appArtifact;
    @Parameter(property="timeout", defaultValue="40")
    protected int timeout = 40;
    @Parameter(property="appDeployName")
    protected String appDeployName;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        if (this.appArchive != null && this.appArtifact != null) {
            throw new MojoExecutionException(messages.getString("error.app.set.twice"));
        }
        if (this.appArtifact != null) {
            Artifact artifact = this.getArtifact(this.appArtifact);
            this.appArchive = artifact.getFile();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based application", this.appArtifact));
        } else if (this.appArchive != null) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based application", this.appArchive));
        } else {
            throw new MojoExecutionException("Nothing to deploy - appArchive or appArtifact must be set.");
        }
        if (!this.appArchive.exists() || this.appArchive.isDirectory()) {
            throw new MojoExecutionException("Application file does not exist or is a directory: " + this.appArchive);
        }
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.deploy.app"), this.appArchive.getCanonicalPath()));
        DeployTask deployTask = (DeployTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:deploy");
        if (deployTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "deploy"));
        }
        deployTask.setInstallDir(this.installDirectory);
        deployTask.setServerName(this.serverName);
        deployTask.setUserDir(this.userDirectory);
        deployTask.setOutputDir(this.outputDirectory);
        deployTask.setFile(this.appArchive);
        deployTask.setDeployName(this.appDeployName);
        deployTask.setTimeout(Long.toString(this.timeout * 1000));
        deployTask.execute();
    }
}

