/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.wasdev.wlp.maven.plugins.XmlDocument;
import org.w3c.dom.Element;

public class LooseConfigData
extends XmlDocument {
    private Map<String, String> dirs = new HashMap<String, String>();
    private Map<String, String> files = new HashMap<String, String>();
    private Map<String, String> archives = new HashMap<String, String>();

    public void addDir(String src, String target) {
        this.dirs.put(src, target);
    }

    public void addFile(String src, String target) {
        this.files.put(src, target);
    }

    public void addArchive(String src, String target) {
        this.archives.put(src, target);
    }

    public void toXmlFile(File xmlFile) throws Exception {
        Element child;
        this.createDocument("archive");
        if (!this.dirs.isEmpty()) {
            for (Map.Entry<String, String> entry : this.dirs.entrySet()) {
                child = this.doc.createElement("dir");
                this.addElement(this.doc.getDocumentElement(), child, entry.getValue(), entry.getKey());
            }
        }
        if (!this.files.isEmpty()) {
            for (Map.Entry<String, String> entry : this.files.entrySet()) {
                child = this.doc.createElement("file");
                this.addElement(this.doc.getDocumentElement(), child, entry.getValue(), entry.getKey());
            }
        }
        if (!this.archives.isEmpty()) {
            for (Map.Entry<String, String> entry : this.archives.entrySet()) {
                child = this.doc.createElement("archive");
                this.addElement(this.doc.getDocumentElement(), child, entry.getValue());
                this.addElement(child, this.doc.createElement("dir"), "/", entry.getKey());
            }
        }
        this.writeXMLDocument(xmlFile);
    }

    private void addElement(Element parent, Element child, String targetAttr, String srcAttr) {
        child.setAttribute("sourceOnDisk", srcAttr);
        this.addElement(parent, child, targetAttr);
    }

    private void addElement(Element parent, Element child, String targetAttr) {
        child.setAttribute("targetInArchive", targetAttr);
        parent.appendChild(child);
    }
}

