/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.jsp;

import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.wasdev.wlp.ant.jsp.CompileJSPs;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="compile-jsp", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompileJspMojo
extends BasicSupport {
    @Parameter
    protected String jspVersion;
    @Parameter(defaultValue="40")
    protected int timeout;

    protected void doExecute() throws Exception {
        CompileJSPs compile = (CompileJSPs)this.ant.createTask("antlib:net/wasdev/wlp/ant:compileJSPs");
        if (compile == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "compileJSPs"));
        }
        compile.setInstallDir(this.installDirectory);
        compile.setSrcdir(new File("src/main/webapp"));
        compile.setDestdir(new File(this.getProject().getBuild().getOutputDirectory()));
        compile.setTempdir(new File(this.getProject().getBuild().getDirectory()));
        compile.setTimeout(this.timeout);
        compile.setCleanup(false);
        List plugins = this.getProject().getBuildPlugins();
        for (Plugin plugin : plugins) {
            Xpp3Dom dom;
            Xpp3Dom val;
            Iterator config;
            if ("org.apache.maven.plugins:maven-compiler-plugin".equals(plugin.getKey())) {
                config = plugin.getConfiguration();
                if (!(config instanceof Xpp3Dom) || (val = (dom = (Xpp3Dom)config).getChild("source")) == null) break;
                compile.setSource(val.getValue());
                break;
            }
            if (!"org.apache.maven.plugins:maven-war-plugin".equals(plugin.getKey()) || !((config = plugin.getConfiguration()) instanceof Xpp3Dom) || (val = (dom = (Xpp3Dom)config).getChild("warSourceDirectory")) == null) continue;
            compile.setSrcdir(new File(val.getValue()));
        }
        TreeSet<String> classpath = new TreeSet<String>();
        classpath.add(this.getProject().getBuild().getOutputDirectory());
        Set dependencies = this.getProject().getArtifacts();
        for (Artifact dep : dependencies) {
            if (!dep.isResolved()) {
                dep = this.resolveArtifact(dep, true);
            }
            if (dep.getFile() != null) {
                if (classpath.add(dep.getFile().getAbsolutePath())) continue;
                this.getLog().warn((CharSequence)("Duplicate dependency: " + dep.getId()));
                continue;
            }
            this.getLog().warn((CharSequence)("Could not find: " + dep.getId()));
        }
        String classpathStr = this.join(classpath, File.pathSeparator);
        this.log.debug((CharSequence)("Classpath: " + classpathStr));
        compile.setClasspath(classpathStr);
        if (this.jspVersion != null) {
            compile.setJspVersion(this.jspVersion);
        }
        compile.execute();
    }

    private String join(Set<String> depPathes, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String str : depPathes) {
            if (sb.length() != 0) {
                sb.append(sep);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    protected void init() throws MojoExecutionException, MojoFailureException {
        boolean doInstall = this.installDirectory == null;
        super.init();
        if (doInstall) {
            try {
                this.installServerAssembly();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failure installing server", e);
            }
        }
    }
}

