/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.utils;

import java.io.File;
import net.wasdev.wlp.common.plugins.util.PluginScenarioException;
import net.wasdev.wlp.maven.plugins.utils.MavenProjectUtil;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SpringBootUtil {
    public static String getSpringBootMavenPluginClassifier(MavenProject project, Log log) {
        String classifier = null;
        try {
            classifier = MavenProjectUtil.getPluginConfigurationString(project, "org.springframework.boot:spring-boot-maven-plugin", "repackage", "classifier");
        }
        catch (PluginScenarioException e) {
            log.debug((CharSequence)"No classifier found for spring-boot-maven-plugin");
        }
        return classifier;
    }

    public static File getSpringBootUberJAR(MavenProject project, Log log) {
        File fatArchive;
        String classifier = SpringBootUtil.getSpringBootMavenPluginClassifier(project, log);
        if (classifier == null) {
            classifier = "";
        }
        if (!classifier.isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (net.wasdev.wlp.common.plugins.util.SpringBootUtil.isSpringBootUberJar((File)(fatArchive = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + classifier + "." + project.getArtifact().getArtifactHandler().getExtension())))) {
            log.info((CharSequence)("Found Spring Boot Uber JAR: " + fatArchive.getAbsolutePath()));
            return fatArchive;
        }
        log.warn((CharSequence)("Spring Boot Uber JAR was not found in expected location: " + fatArchive.getAbsolutePath()));
        return null;
    }
}

