/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * This section is used to control the recognition process and configure settings that apply only to specific barcode types.
 */
@Schema(description = "This section is used to control the recognition process and configure settings that apply only to specific barcode types.")
@JsonPropertyOrder({
  OperationBarcodeSelection.JSON_PROPERTY_ALLOWED_LENGTHS,
  OperationBarcodeSelection.JSON_PROPERTY_BARCODE39_CHECK_DIGIT,
  OperationBarcodeSelection.JSON_PROPERTY_CHARSET,
  OperationBarcodeSelection.JSON_PROPERTY_CODABAR_START_END_DIGITS,
  OperationBarcodeSelection.JSON_PROPERTY_FORMATS,
  OperationBarcodeSelection.JSON_PROPERTY_GS1,
  OperationBarcodeSelection.JSON_PROPERTY_PAGES,
  OperationBarcodeSelection.JSON_PROPERTY_PURE_BARCODE,
  OperationBarcodeSelection.JSON_PROPERTY_RESOLUTION,
  OperationBarcodeSelection.JSON_PROPERTY_SCAN_AREA,
  OperationBarcodeSelection.JSON_PROPERTY_TRY_HARDER,
  OperationBarcodeSelection.JSON_PROPERTY_UPC_EAN_EXTENSIONS
})
@JsonTypeName("Operation_BarcodeSelection")

public class OperationBarcodeSelection {
  public static final String JSON_PROPERTY_ALLOWED_LENGTHS = "allowedLengths";
  private String allowedLengths = "";

  public static final String JSON_PROPERTY_BARCODE39_CHECK_DIGIT = "barcode39CheckDigit";
  private Boolean barcode39CheckDigit = false;

  public static final String JSON_PROPERTY_CHARSET = "charset";
  private String charset = "utf-8";

  public static final String JSON_PROPERTY_CODABAR_START_END_DIGITS = "codabarStartEndDigits";
  private Boolean codabarStartEndDigits = false;

  public static final String JSON_PROPERTY_FORMATS = "formats";
  private String formats = "";

  public static final String JSON_PROPERTY_GS1 = "gs1";
  private Boolean gs1 = false;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public static final String JSON_PROPERTY_PURE_BARCODE = "pureBarcode";
  private Boolean pureBarcode = false;

  public static final String JSON_PROPERTY_RESOLUTION = "resolution";
  private Integer resolution = 200;

  public static final String JSON_PROPERTY_SCAN_AREA = "scanArea";
  private OperationRectangle scanArea;

  public static final String JSON_PROPERTY_TRY_HARDER = "tryHarder";
  private Boolean tryHarder = true;

  public static final String JSON_PROPERTY_UPC_EAN_EXTENSIONS = "upcEanExtensions";
  private String upcEanExtensions = "";

  public OperationBarcodeSelection() {
  }

  public OperationBarcodeSelection allowedLengths(String allowedLengths) {
    
    this.allowedLengths = allowedLengths;
    return this;
  }

  /**
   * If this value is set, it will limit the allowed lengths for encoded values. In other words, barcodes with a length that is not listed will be ignored. (Example: \&quot;13,8,25\&quot;)
   * @return allowedLengths
   **/
  @Nullable
  @Schema(name = "If this value is set, it will limit the allowed lengths for encoded values. In other words, barcodes with a length that is not listed will be ignored. (Example: \"13,8,25\")")
  @JsonProperty(JSON_PROPERTY_ALLOWED_LENGTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAllowedLengths() {
    return allowedLengths;
  }


  @JsonProperty(JSON_PROPERTY_ALLOWED_LENGTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedLengths(String allowedLengths) {
    this.allowedLengths = allowedLengths;
  }


  public OperationBarcodeSelection barcode39CheckDigit(Boolean barcode39CheckDigit) {
    
    this.barcode39CheckDigit = barcode39CheckDigit;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, the system will assume that all recognized Code 39 barcodes contain a correct check digit.
   * @return barcode39CheckDigit
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", the system will assume that all recognized Code 39 barcodes contain a correct check digit.")
  @JsonProperty(JSON_PROPERTY_BARCODE39_CHECK_DIGIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBarcode39CheckDigit() {
    return barcode39CheckDigit;
  }


  @JsonProperty(JSON_PROPERTY_BARCODE39_CHECK_DIGIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBarcode39CheckDigit(Boolean barcode39CheckDigit) {
    this.barcode39CheckDigit = barcode39CheckDigit;
  }


  public OperationBarcodeSelection charset(String charset) {
    
    this.charset = charset;
    return this;
  }

  /**
   * Used to specify the character set in which the barcode contents are stored.
   * @return charset
   **/
  @Nullable
  @Schema(name = "Used to specify the character set in which the barcode contents are stored.")
  @JsonProperty(JSON_PROPERTY_CHARSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCharset() {
    return charset;
  }


  @JsonProperty(JSON_PROPERTY_CHARSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharset(String charset) {
    this.charset = charset;
  }


  public OperationBarcodeSelection codabarStartEndDigits(Boolean codabarStartEndDigits) {
    
    this.codabarStartEndDigits = codabarStartEndDigits;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, the start and stop symbols of recognized Codabar barcodes will be read instead of removed during recognition.
   * @return codabarStartEndDigits
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", the start and stop symbols of recognized Codabar barcodes will be read instead of removed during recognition.")
  @JsonProperty(JSON_PROPERTY_CODABAR_START_END_DIGITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCodabarStartEndDigits() {
    return codabarStartEndDigits;
  }


  @JsonProperty(JSON_PROPERTY_CODABAR_START_END_DIGITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCodabarStartEndDigits(Boolean codabarStartEndDigits) {
    this.codabarStartEndDigits = codabarStartEndDigits;
  }


  public OperationBarcodeSelection formats(String formats) {
    
    this.formats = formats;
    return this;
  }

  /**
   * Used to define the list of barcodes (comma-separated) that should be searched for. There must be at least one barcode format here; otherwise, no search will be run. The names are the same as those used in &#x60;&lt;add&gt;&#x60;, i.e., the following are the barcode names available:  *   qrcode *   aztec *   codabar *   code128 *   code39 *   datamatrix *   ean13 *   ean8 *   itf *   pdf417 *   upca
   * @return formats
   **/
  @NotNull
  @Schema(required = true, name = "Used to define the list of barcodes (comma-separated) that should be searched for. There must be at least one barcode format here; otherwise, no search will be run. The names are the same as those used in `<add>`, i.e., the following are the barcode names available:  *   qrcode *   aztec *   codabar *   code128 *   code39 *   datamatrix *   ean13 *   ean8 *   itf *   pdf417 *   upca")
  @JsonProperty(JSON_PROPERTY_FORMATS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFormats() {
    return formats;
  }


  @JsonProperty(JSON_PROPERTY_FORMATS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFormats(String formats) {
    this.formats = formats;
  }


  public OperationBarcodeSelection gs1(Boolean gs1) {
    
    this.gs1 = gs1;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, the system will assume that all recognized barcodes are GS1-compliant barcodes, and the way all processes behave and work will be adjusted accordingly (for instance, the way in which the FNC1 character is handled for Code 128)
   * @return gs1
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", the system will assume that all recognized barcodes are GS1-compliant barcodes, and the way all processes behave and work will be adjusted accordingly (for instance, the way in which the FNC1 character is handled for Code 128)")
  @JsonProperty(JSON_PROPERTY_GS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGs1() {
    return gs1;
  }


  @JsonProperty(JSON_PROPERTY_GS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGs1(Boolean gs1) {
    this.gs1 = gs1;
  }


  public OperationBarcodeSelection pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * The page range within which barcodes should be scanned. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \&quot;1-10\&quot; or \&quot;1,2,5-10\&quot;)
   * @return pages
   **/
  @Nullable
  @Schema(name = "The page range within which barcodes should be scanned. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationBarcodeSelection pureBarcode(Boolean pureBarcode) {
    
    this.pureBarcode = pureBarcode;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, the system will assume that the source document being scanned (limited by &#x60;&lt;scanArea&gt;&#x60;) does not contain any elements other than the barcode. This option can speed up the recognition process significantly. If, however, this option is enabled and there are elements other than a barcode, recognition may fail completely.
   * @return pureBarcode
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", the system will assume that the source document being scanned (limited by `<scanArea>`) does not contain any elements other than the barcode. This option can speed up the recognition process significantly. If, however, this option is enabled and there are elements other than a barcode, recognition may fail completely.")
  @JsonProperty(JSON_PROPERTY_PURE_BARCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPureBarcode() {
    return pureBarcode;
  }


  @JsonProperty(JSON_PROPERTY_PURE_BARCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPureBarcode(Boolean pureBarcode) {
    this.pureBarcode = pureBarcode;
  }


  public OperationBarcodeSelection resolution(Integer resolution) {
    
    this.resolution = resolution;
    return this;
  }

  /**
   * Used to select the resolution for the recognition operation. Depending on the barcode&#39;s format and quality, higher or lower values may yield better results (in any case, higher values will slow down processing).
   * minimum: 1
   * @return resolution
   **/
  @Nullable
  @Schema(name = "Used to select the resolution for the recognition operation. Depending on the barcode's format and quality, higher or lower values may yield better results (in any case, higher values will slow down processing).")
  @JsonProperty(JSON_PROPERTY_RESOLUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getResolution() {
    return resolution;
  }


  @JsonProperty(JSON_PROPERTY_RESOLUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResolution(Integer resolution) {
    this.resolution = resolution;
  }


  public OperationBarcodeSelection scanArea(OperationRectangle scanArea) {
    
    this.scanArea = scanArea;
    return this;
  }

  /**
   * Get scanArea
   * @return scanArea
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_SCAN_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OperationRectangle getScanArea() {
    return scanArea;
  }


  @JsonProperty(JSON_PROPERTY_SCAN_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setScanArea(OperationRectangle scanArea) {
    this.scanArea = scanArea;
  }


  public OperationBarcodeSelection tryHarder(Boolean tryHarder) {
    
    this.tryHarder = tryHarder;
    return this;
  }

  /**
   * If this value is set to \&quot;true\&quot;, more computing time will be invested in order to guarantee successful recognition. For example, the system will also scan for barcodes along the vertical axis.
   * @return tryHarder
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true\", more computing time will be invested in order to guarantee successful recognition. For example, the system will also scan for barcodes along the vertical axis.")
  @JsonProperty(JSON_PROPERTY_TRY_HARDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTryHarder() {
    return tryHarder;
  }


  @JsonProperty(JSON_PROPERTY_TRY_HARDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTryHarder(Boolean tryHarder) {
    this.tryHarder = tryHarder;
  }


  public OperationBarcodeSelection upcEanExtensions(String upcEanExtensions) {
    
    this.upcEanExtensions = upcEanExtensions;
    return this;
  }

  /**
   * If this value is set, it will limit the allowed lengths for encoded EAN and UPC Extensions. In other words, barcodes with an Extension length that is not listed will be ignored. (Example: \&quot;2,5\&quot;)
   * @return upcEanExtensions
   **/
  @Nullable
  @Schema(name = "If this value is set, it will limit the allowed lengths for encoded EAN and UPC Extensions. In other words, barcodes with an Extension length that is not listed will be ignored. (Example: \"2,5\")")
  @JsonProperty(JSON_PROPERTY_UPC_EAN_EXTENSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpcEanExtensions() {
    return upcEanExtensions;
  }


  @JsonProperty(JSON_PROPERTY_UPC_EAN_EXTENSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpcEanExtensions(String upcEanExtensions) {
    this.upcEanExtensions = upcEanExtensions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationBarcodeSelection operationBarcodeSelection = (OperationBarcodeSelection) o;
    return Objects.equals(this.allowedLengths, operationBarcodeSelection.allowedLengths) &&
        Objects.equals(this.barcode39CheckDigit, operationBarcodeSelection.barcode39CheckDigit) &&
        Objects.equals(this.charset, operationBarcodeSelection.charset) &&
        Objects.equals(this.codabarStartEndDigits, operationBarcodeSelection.codabarStartEndDigits) &&
        Objects.equals(this.formats, operationBarcodeSelection.formats) &&
        Objects.equals(this.gs1, operationBarcodeSelection.gs1) &&
        Objects.equals(this.pages, operationBarcodeSelection.pages) &&
        Objects.equals(this.pureBarcode, operationBarcodeSelection.pureBarcode) &&
        Objects.equals(this.resolution, operationBarcodeSelection.resolution) &&
        Objects.equals(this.scanArea, operationBarcodeSelection.scanArea) &&
        Objects.equals(this.tryHarder, operationBarcodeSelection.tryHarder) &&
        Objects.equals(this.upcEanExtensions, operationBarcodeSelection.upcEanExtensions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowedLengths, barcode39CheckDigit, charset, codabarStartEndDigits, formats, gs1, pages, pureBarcode, resolution, scanArea, tryHarder, upcEanExtensions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationBarcodeSelection {\n");
    sb.append("    allowedLengths: ").append(toIndentedString(allowedLengths)).append("\n");
    sb.append("    barcode39CheckDigit: ").append(toIndentedString(barcode39CheckDigit)).append("\n");
    sb.append("    charset: ").append(toIndentedString(charset)).append("\n");
    sb.append("    codabarStartEndDigits: ").append(toIndentedString(codabarStartEndDigits)).append("\n");
    sb.append("    formats: ").append(toIndentedString(formats)).append("\n");
    sb.append("    gs1: ").append(toIndentedString(gs1)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    pureBarcode: ").append(toIndentedString(pureBarcode)).append("\n");
    sb.append("    resolution: ").append(toIndentedString(resolution)).append("\n");
    sb.append("    scanArea: ").append(toIndentedString(scanArea)).append("\n");
    sb.append("    tryHarder: ").append(toIndentedString(tryHarder)).append("\n");
    sb.append("    upcEanExtensions: ").append(toIndentedString(upcEanExtensions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
