/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Performs the conversion of a document.
 */
@Schema(description = "Performs the conversion of a document.")
@JsonPropertyOrder({
  OperationConverter.JSON_PROPERTY_ACCESS_PASSWORD,
  OperationConverter.JSON_PROPERTY_COMPRESSION,
  OperationConverter.JSON_PROPERTY_DPI,
  OperationConverter.JSON_PROPERTY_EMBED_FONTS,
  OperationConverter.JSON_PROPERTY_FILE_EXTENSION,
  OperationConverter.JSON_PROPERTY_HTML,
  OperationConverter.JSON_PROPERTY_IMAGE,
  OperationConverter.JSON_PROPERTY_JPEG_QUALITY,
  OperationConverter.JSON_PROPERTY_MAIL,
  OperationConverter.JSON_PROPERTY_MAX_RECURSION,
  OperationConverter.JSON_PROPERTY_OFFICE_BRIDGE,
  OperationConverter.JSON_PROPERTY_PAGE,
  OperationConverter.JSON_PROPERTY_PAGES,
  OperationConverter.JSON_PROPERTY_PDFA,
  OperationConverter.JSON_PROPERTY_REDUCE_RESOLUTION,
  OperationConverter.JSON_PROPERTY_REPORT,
  OperationConverter.JSON_PROPERTY_SHARE_POINT_BRIDGE,
  OperationConverter.JSON_PROPERTY_SIGNATURE,
  OperationConverter.JSON_PROPERTY_TEMPLATE,
  OperationConverter.JSON_PROPERTY_TEXT,
  OperationConverter.JSON_PROPERTY_TRANSFORM
})
@JsonTypeName("Operation_Converter")

public class OperationConverter {
  public static final String JSON_PROPERTY_ACCESS_PASSWORD = "accessPassword";
  private String accessPassword = "";

  public static final String JSON_PROPERTY_COMPRESSION = "compression";
  private Boolean compression = true;

  public static final String JSON_PROPERTY_DPI = "dpi";
  private Integer dpi = 300;

  public static final String JSON_PROPERTY_EMBED_FONTS = "embedFonts";
  private Boolean embedFonts = false;

  public static final String JSON_PROPERTY_FILE_EXTENSION = "fileExtension";
  private String fileExtension = "";

  public static final String JSON_PROPERTY_HTML = "html";
  private OperationConverterHtml html;

  public static final String JSON_PROPERTY_IMAGE = "image";
  private OperationConverterImage image;

  public static final String JSON_PROPERTY_JPEG_QUALITY = "jpegQuality";
  private Integer jpegQuality = 90;

  public static final String JSON_PROPERTY_MAIL = "mail";
  private OperationConverterMail mail;

  public static final String JSON_PROPERTY_MAX_RECURSION = "maxRecursion";
  private Integer maxRecursion = 1;

  public static final String JSON_PROPERTY_OFFICE_BRIDGE = "officeBridge";
  private Object officeBridge;

  public static final String JSON_PROPERTY_PAGE = "page";
  private OperationConverterPage page;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public static final String JSON_PROPERTY_PDFA = "pdfa";
  private OperationPdfa pdfa;

  public static final String JSON_PROPERTY_REDUCE_RESOLUTION = "reduceResolution";
  private Boolean reduceResolution = false;

  public static final String JSON_PROPERTY_REPORT = "report";
  private OperationConverterReport report;

  public static final String JSON_PROPERTY_SHARE_POINT_BRIDGE = "sharePointBridge";
  private Object sharePointBridge;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private OperationSignature signature;

  public static final String JSON_PROPERTY_TEMPLATE = "template";
  private OperationConverterTemplate template;

  public static final String JSON_PROPERTY_TEXT = "text";
  private OperationConverterText text;

  public static final String JSON_PROPERTY_TRANSFORM = "transform";
  private OperationConverterTransform transform;

  public OperationConverter() {
  }

  public OperationConverter accessPassword(String accessPassword) {
    
    this.accessPassword = accessPassword;
    return this;
  }

  /**
   * This parameter can be used to declare a password that will be used to open the source document if it is protected.  **Important:** This option is currently only supported for Microsoft Office 97-2003 binary documents and Microsoft Office 2007 documents. Only the default password methods are supported. Encryption based on digital certificates is not supported.
   * @return accessPassword
   **/
  @Nullable
  @Schema(name = "This parameter can be used to declare a password that will be used to open the source document if it is protected.  **Important:** This option is currently only supported for Microsoft Office 97-2003 binary documents and Microsoft Office 2007 documents. Only the default password methods are supported. Encryption based on digital certificates is not supported.")
  @JsonProperty(JSON_PROPERTY_ACCESS_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccessPassword() {
    return accessPassword;
  }


  @JsonProperty(JSON_PROPERTY_ACCESS_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessPassword(String accessPassword) {
    this.accessPassword = accessPassword;
  }


  public OperationConverter compression(Boolean compression) {
    
    this.compression = compression;
    return this;
  }

  /**
   * If \&quot;true,\&quot; the data objects in the PDF document will be compressed (ZLib compression), reducing the size of the document.
   * @return compression
   **/
  @Nullable
  @Schema(name = "If \"true,\" the data objects in the PDF document will be compressed (ZLib compression), reducing the size of the document.")
  @JsonProperty(JSON_PROPERTY_COMPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCompression() {
    return compression;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompression(Boolean compression) {
    this.compression = compression;
  }


  public OperationConverter dpi(Integer dpi) {
    
    this.dpi = dpi;
    return this;
  }

  /**
   * Used to set the DPI solution (pixels per inch) for images.
   * minimum: 0
   * maximum: 9600
   * @return dpi
   **/
  @Nullable
  @Schema(name = "Used to set the DPI solution (pixels per inch) for images.")
  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDpi() {
    return dpi;
  }


  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDpi(Integer dpi) {
    this.dpi = dpi;
  }


  public OperationConverter embedFonts(Boolean embedFonts) {
    
    this.embedFonts = embedFonts;
    return this;
  }

  /**
   * If \&quot;true,\&quot; fonts will be embedded in the PDF document that is created.  **Important:**: If the original fonts are not available on the conversion system, substitute fonts may be embedded instead.  **Important:**: If, after the conversion, you want to convert the PDF document to PDF/A, you should not embed any of the fonts, but should instead let the \&quot;Pdfa\&quot; web service do this.
   * @return embedFonts
   **/
  @Nullable
  @Schema(name = "If \"true,\" fonts will be embedded in the PDF document that is created.  **Important:**: If the original fonts are not available on the conversion system, substitute fonts may be embedded instead.  **Important:**: If, after the conversion, you want to convert the PDF document to PDF/A, you should not embed any of the fonts, but should instead let the \"Pdfa\" web service do this.")
  @JsonProperty(JSON_PROPERTY_EMBED_FONTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEmbedFonts() {
    return embedFonts;
  }


  @JsonProperty(JSON_PROPERTY_EMBED_FONTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmbedFonts(Boolean embedFonts) {
    this.embedFonts = embedFonts;
  }


  public OperationConverter fileExtension(String fileExtension) {
    
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * If you use this attribute to enter an extension for the file (e.g., \&quot;doc\&quot;) that is currently being processed, automatic file format detection will be disabled. Normally, webPDF does not detect file formats based on the corresponding file extension, but on the file contents instead. Accordingly, webPDF will analyze the file and assign the file the appropriate \&quot;mime-type\&quot; so that the appropriate file converter can then be selected.  **Important:**: You should only set a file extension in exceptional cases, as this will completely disable automatic detection. If, for instance, you specify an extension for which webPDF does not have a \&quot;mime-type,\&quot; the conversion will fail.
   * @return fileExtension
   **/
  @Nullable
  @Schema(name = "If you use this attribute to enter an extension for the file (e.g., \"doc\") that is currently being processed, automatic file format detection will be disabled. Normally, webPDF does not detect file formats based on the corresponding file extension, but on the file contents instead. Accordingly, webPDF will analyze the file and assign the file the appropriate \"mime-type\" so that the appropriate file converter can then be selected.  **Important:**: You should only set a file extension in exceptional cases, as this will completely disable automatic detection. If, for instance, you specify an extension for which webPDF does not have a \"mime-type,\" the conversion will fail.")
  @JsonProperty(JSON_PROPERTY_FILE_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileExtension() {
    return fileExtension;
  }


  @JsonProperty(JSON_PROPERTY_FILE_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileExtension(String fileExtension) {
    this.fileExtension = fileExtension;
  }


  public OperationConverter html(OperationConverterHtml html) {
    
    this.html = html;
    return this;
  }

  /**
   * Get html
   * @return html
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterHtml getHtml() {
    return html;
  }


  @JsonProperty(JSON_PROPERTY_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtml(OperationConverterHtml html) {
    this.html = html;
  }


  public OperationConverter image(OperationConverterImage image) {
    
    this.image = image;
    return this;
  }

  /**
   * Get image
   * @return image
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterImage getImage() {
    return image;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage(OperationConverterImage image) {
    this.image = image;
  }


  public OperationConverter jpegQuality(Integer jpegQuality) {
    
    this.jpegQuality = jpegQuality;
    return this;
  }

  /**
   * Used to set the quality (as a percentage) of JPEG images in the PDF document.
   * minimum: 0
   * maximum: 100
   * @return jpegQuality
   **/
  @Nullable
  @Schema(name = "Used to set the quality (as a percentage) of JPEG images in the PDF document.")
  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getJpegQuality() {
    return jpegQuality;
  }


  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJpegQuality(Integer jpegQuality) {
    this.jpegQuality = jpegQuality;
  }


  public OperationConverter mail(OperationConverterMail mail) {
    
    this.mail = mail;
    return this;
  }

  /**
   * Get mail
   * @return mail
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterMail getMail() {
    return mail;
  }


  @JsonProperty(JSON_PROPERTY_MAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMail(OperationConverterMail mail) {
    this.mail = mail;
  }


  public OperationConverter maxRecursion(Integer maxRecursion) {
    
    this.maxRecursion = maxRecursion;
    return this;
  }

  /**
   * Sets the maximum recursions, that may occur when converting a document&#39;s attachments.  **Important:** This parameter is intended for internal use only. Please only use this, if you really are sure you need to do so.
   * minimum: 1
   * @return maxRecursion
   **/
  @Nullable
  @Schema(name = "Sets the maximum recursions, that may occur when converting a document's attachments.  **Important:** This parameter is intended for internal use only. Please only use this, if you really are sure you need to do so.")
  @JsonProperty(JSON_PROPERTY_MAX_RECURSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxRecursion() {
    return maxRecursion;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RECURSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRecursion(Integer maxRecursion) {
    this.maxRecursion = maxRecursion;
  }


  public OperationConverter officeBridge(Object officeBridge) {
    
    this.officeBridge = officeBridge;
    return this;
  }

  /**
   * Used to specify whether \&quot;Office Bridge\&quot; should be used when converting Word, Excel, and PowerPoint documents. If this element is set (and Office Bridge is enabled), the document will be converted using the Office software installed on the server.
   * @return officeBridge
   **/
  @Nullable
  @Schema(name = "Used to specify whether \"Office Bridge\" should be used when converting Word, Excel, and PowerPoint documents. If this element is set (and Office Bridge is enabled), the document will be converted using the Office software installed on the server.")
  @JsonProperty(JSON_PROPERTY_OFFICE_BRIDGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getOfficeBridge() {
    return officeBridge;
  }


  @JsonProperty(JSON_PROPERTY_OFFICE_BRIDGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfficeBridge(Object officeBridge) {
    this.officeBridge = officeBridge;
  }


  public OperationConverter page(OperationConverterPage page) {
    
    this.page = page;
    return this;
  }

  /**
   * Get page
   * @return page
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterPage getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(OperationConverterPage page) {
    this.page = page;
  }


  public OperationConverter pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * A text that defines the page range for the export. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \&quot;1-10\&quot; or \&quot;1,2,5-10\&quot;)
   * @return pages
   **/
  @Nullable
  @Schema(name = "A text that defines the page range for the export. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationConverter pdfa(OperationPdfa pdfa) {
    
    this.pdfa = pdfa;
    return this;
  }

  /**
   * Get pdfa
   * @return pdfa
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PDFA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPdfa getPdfa() {
    return pdfa;
  }


  @JsonProperty(JSON_PROPERTY_PDFA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPdfa(OperationPdfa pdfa) {
    this.pdfa = pdfa;
  }


  public OperationConverter reduceResolution(Boolean reduceResolution) {
    
    this.reduceResolution = reduceResolution;
    return this;
  }

  /**
   * If \&quot;true,\&quot; then the DPI resolution of graphics is reduced. The reduction value is set with \&quot;dpi.\&quot;
   * @return reduceResolution
   **/
  @Nullable
  @Schema(name = "If \"true,\" then the DPI resolution of graphics is reduced. The reduction value is set with \"dpi.\"")
  @JsonProperty(JSON_PROPERTY_REDUCE_RESOLUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReduceResolution() {
    return reduceResolution;
  }


  @JsonProperty(JSON_PROPERTY_REDUCE_RESOLUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReduceResolution(Boolean reduceResolution) {
    this.reduceResolution = reduceResolution;
  }


  public OperationConverter report(OperationConverterReport report) {
    
    this.report = report;
    return this;
  }

  /**
   * Get report
   * @return report
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterReport getReport() {
    return report;
  }


  @JsonProperty(JSON_PROPERTY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReport(OperationConverterReport report) {
    this.report = report;
  }


  public OperationConverter sharePointBridge(Object sharePointBridge) {
    
    this.sharePointBridge = sharePointBridge;
    return this;
  }

  /**
   * Used to specify whether \&quot;SharePoint Bridge\&quot; should be used when converting a Word document. If the element is set, the Word document will be converted using the SharePoint service (if SharePoint Bridge is enabled).
   * @return sharePointBridge
   **/
  @Nullable
  @Schema(name = "Used to specify whether \"SharePoint Bridge\" should be used when converting a Word document. If the element is set, the Word document will be converted using the SharePoint service (if SharePoint Bridge is enabled).")
  @JsonProperty(JSON_PROPERTY_SHARE_POINT_BRIDGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getSharePointBridge() {
    return sharePointBridge;
  }


  @JsonProperty(JSON_PROPERTY_SHARE_POINT_BRIDGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSharePointBridge(Object sharePointBridge) {
    this.sharePointBridge = sharePointBridge;
  }


  public OperationConverter signature(OperationSignature signature) {
    
    this.signature = signature;
    return this;
  }

  /**
   * Get signature
   * @return signature
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSignature getSignature() {
    return signature;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignature(OperationSignature signature) {
    this.signature = signature;
  }


  public OperationConverter template(OperationConverterTemplate template) {
    
    this.template = template;
    return this;
  }

  /**
   * Get template
   * @return template
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterTemplate getTemplate() {
    return template;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTemplate(OperationConverterTemplate template) {
    this.template = template;
  }


  public OperationConverter text(OperationConverterText text) {
    
    this.text = text;
    return this;
  }

  /**
   * Get text
   * @return text
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterText getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(OperationConverterText text) {
    this.text = text;
  }


  public OperationConverter transform(OperationConverterTransform transform) {
    
    this.transform = transform;
    return this;
  }

  /**
   * Get transform
   * @return transform
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TRANSFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterTransform getTransform() {
    return transform;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransform(OperationConverterTransform transform) {
    this.transform = transform;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationConverter operationConverter = (OperationConverter) o;
    return Objects.equals(this.accessPassword, operationConverter.accessPassword) &&
        Objects.equals(this.compression, operationConverter.compression) &&
        Objects.equals(this.dpi, operationConverter.dpi) &&
        Objects.equals(this.embedFonts, operationConverter.embedFonts) &&
        Objects.equals(this.fileExtension, operationConverter.fileExtension) &&
        Objects.equals(this.html, operationConverter.html) &&
        Objects.equals(this.image, operationConverter.image) &&
        Objects.equals(this.jpegQuality, operationConverter.jpegQuality) &&
        Objects.equals(this.mail, operationConverter.mail) &&
        Objects.equals(this.maxRecursion, operationConverter.maxRecursion) &&
        Objects.equals(this.officeBridge, operationConverter.officeBridge) &&
        Objects.equals(this.page, operationConverter.page) &&
        Objects.equals(this.pages, operationConverter.pages) &&
        Objects.equals(this.pdfa, operationConverter.pdfa) &&
        Objects.equals(this.reduceResolution, operationConverter.reduceResolution) &&
        Objects.equals(this.report, operationConverter.report) &&
        Objects.equals(this.sharePointBridge, operationConverter.sharePointBridge) &&
        Objects.equals(this.signature, operationConverter.signature) &&
        Objects.equals(this.template, operationConverter.template) &&
        Objects.equals(this.text, operationConverter.text) &&
        Objects.equals(this.transform, operationConverter.transform);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessPassword, compression, dpi, embedFonts, fileExtension, html, image, jpegQuality, mail, maxRecursion, officeBridge, page, pages, pdfa, reduceResolution, report, sharePointBridge, signature, template, text, transform);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationConverter {\n");
    sb.append("    accessPassword: ").append(toIndentedString(accessPassword)).append("\n");
    sb.append("    compression: ").append(toIndentedString(compression)).append("\n");
    sb.append("    dpi: ").append(toIndentedString(dpi)).append("\n");
    sb.append("    embedFonts: ").append(toIndentedString(embedFonts)).append("\n");
    sb.append("    fileExtension: ").append(toIndentedString(fileExtension)).append("\n");
    sb.append("    html: ").append(toIndentedString(html)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    jpegQuality: ").append(toIndentedString(jpegQuality)).append("\n");
    sb.append("    mail: ").append(toIndentedString(mail)).append("\n");
    sb.append("    maxRecursion: ").append(toIndentedString(maxRecursion)).append("\n");
    sb.append("    officeBridge: ").append(toIndentedString(officeBridge)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    pdfa: ").append(toIndentedString(pdfa)).append("\n");
    sb.append("    reduceResolution: ").append(toIndentedString(reduceResolution)).append("\n");
    sb.append("    report: ").append(toIndentedString(report)).append("\n");
    sb.append("    sharePointBridge: ").append(toIndentedString(sharePointBridge)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    transform: ").append(toIndentedString(transform)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
