/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The fitRectangle element is used to specify a location within the document. It will jump to a page in the document and set a zoom factor that will ensure, as far as possible, that a rectangle produced by the offsets from the page margins is displayed.
 */
@Schema(description = "The fitRectangle element is used to specify a location within the document. It will jump to a page in the document and set a zoom factor that will ensure, as far as possible, that a rectangle produced by the offsets from the page margins is displayed.")
@JsonPropertyOrder({
  OperationFitRectangleDestinationFitRectangle.JSON_PROPERTY_BOTTOM_OFFSET,
  OperationFitRectangleDestinationFitRectangle.JSON_PROPERTY_LEFT_OFFSET,
  OperationFitRectangleDestinationFitRectangle.JSON_PROPERTY_METRICS,
  OperationFitRectangleDestinationFitRectangle.JSON_PROPERTY_PAGE,
  OperationFitRectangleDestinationFitRectangle.JSON_PROPERTY_RIGHT_OFFSET,
  OperationFitRectangleDestinationFitRectangle.JSON_PROPERTY_TOP_OFFSET
})
@JsonTypeName("Operation_FitRectangleDestination_fitRectangle")

public class OperationFitRectangleDestinationFitRectangle {
  public static final String JSON_PROPERTY_BOTTOM_OFFSET = "bottomOffset";
  private Integer bottomOffset = 0;

  public static final String JSON_PROPERTY_LEFT_OFFSET = "leftOffset";
  private Integer leftOffset = 0;

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   */
  public enum MetricsEnum {
    PT("pt"),
    
    PC("pc"),
    
    PX("px"),
    
    MM("mm"),
    
    IN("in");

    private String value;

    MetricsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MetricsEnum fromValue(String value) {
      for (MetricsEnum b : MetricsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private MetricsEnum metrics = MetricsEnum.PX;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 1;

  public static final String JSON_PROPERTY_RIGHT_OFFSET = "rightOffset";
  private Integer rightOffset = 0;

  public static final String JSON_PROPERTY_TOP_OFFSET = "topOffset";
  private Integer topOffset = 0;

  public OperationFitRectangleDestinationFitRectangle() {
  }

  public OperationFitRectangleDestinationFitRectangle bottomOffset(Integer bottomOffset) {
    
    this.bottomOffset = bottomOffset;
    return this;
  }

  /**
   * The area&#39;s offset from the bottom page margin.
   * @return bottomOffset
   **/
  @Nullable
  @Schema(name = "The area's offset from the bottom page margin.")
  @JsonProperty(JSON_PROPERTY_BOTTOM_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBottomOffset() {
    return bottomOffset;
  }


  @JsonProperty(JSON_PROPERTY_BOTTOM_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBottomOffset(Integer bottomOffset) {
    this.bottomOffset = bottomOffset;
  }


  public OperationFitRectangleDestinationFitRectangle leftOffset(Integer leftOffset) {
    
    this.leftOffset = leftOffset;
    return this;
  }

  /**
   * The area&#39;s offset from the left page margin.
   * @return leftOffset
   **/
  @Nullable
  @Schema(name = "The area's offset from the left page margin.")
  @JsonProperty(JSON_PROPERTY_LEFT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLeftOffset() {
    return leftOffset;
  }


  @JsonProperty(JSON_PROPERTY_LEFT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLeftOffset(Integer leftOffset) {
    this.leftOffset = leftOffset;
  }


  public OperationFitRectangleDestinationFitRectangle metrics(MetricsEnum metrics) {
    
    this.metrics = metrics;
    return this;
  }

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   * @return metrics
   **/
  @Nullable
  @Schema(name = "Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetricsEnum getMetrics() {
    return metrics;
  }


  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetrics(MetricsEnum metrics) {
    this.metrics = metrics;
  }


  public OperationFitRectangleDestinationFitRectangle page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * The document page to which the jump will be.
   * minimum: 1
   * @return page
   **/
  @Nullable
  @Schema(name = "The document page to which the jump will be.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public OperationFitRectangleDestinationFitRectangle rightOffset(Integer rightOffset) {
    
    this.rightOffset = rightOffset;
    return this;
  }

  /**
   * The area&#39;s offset from the right page margin.
   * @return rightOffset
   **/
  @Nullable
  @Schema(name = "The area's offset from the right page margin.")
  @JsonProperty(JSON_PROPERTY_RIGHT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRightOffset() {
    return rightOffset;
  }


  @JsonProperty(JSON_PROPERTY_RIGHT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRightOffset(Integer rightOffset) {
    this.rightOffset = rightOffset;
  }


  public OperationFitRectangleDestinationFitRectangle topOffset(Integer topOffset) {
    
    this.topOffset = topOffset;
    return this;
  }

  /**
   * The area&#39;s offset from the top page margin.
   * @return topOffset
   **/
  @Nullable
  @Schema(name = "The area's offset from the top page margin.")
  @JsonProperty(JSON_PROPERTY_TOP_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTopOffset() {
    return topOffset;
  }


  @JsonProperty(JSON_PROPERTY_TOP_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTopOffset(Integer topOffset) {
    this.topOffset = topOffset;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationFitRectangleDestinationFitRectangle operationFitRectangleDestinationFitRectangle = (OperationFitRectangleDestinationFitRectangle) o;
    return Objects.equals(this.bottomOffset, operationFitRectangleDestinationFitRectangle.bottomOffset) &&
        Objects.equals(this.leftOffset, operationFitRectangleDestinationFitRectangle.leftOffset) &&
        Objects.equals(this.metrics, operationFitRectangleDestinationFitRectangle.metrics) &&
        Objects.equals(this.page, operationFitRectangleDestinationFitRectangle.page) &&
        Objects.equals(this.rightOffset, operationFitRectangleDestinationFitRectangle.rightOffset) &&
        Objects.equals(this.topOffset, operationFitRectangleDestinationFitRectangle.topOffset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bottomOffset, leftOffset, metrics, page, rightOffset, topOffset);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationFitRectangleDestinationFitRectangle {\n");
    sb.append("    bottomOffset: ").append(toIndentedString(bottomOffset)).append("\n");
    sb.append("    leftOffset: ").append(toIndentedString(leftOffset)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    rightOffset: ").append(toIndentedString(rightOffset)).append("\n");
    sb.append("    topOffset: ").append(toIndentedString(topOffset)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
