/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * An annotation that adds a note icon to a page.
 */
@Schema(description = "An annotation that adds a note icon to a page.")
@JsonPropertyOrder({
  OperationTextAnnotation.JSON_PROPERTY_APPEARANCE_GENERATION,
  OperationTextAnnotation.JSON_PROPERTY_COLOR,
  OperationTextAnnotation.JSON_PROPERTY_CONTENTS,
  OperationTextAnnotation.JSON_PROPERTY_CREATOR,
  OperationTextAnnotation.JSON_PROPERTY_CUSTOM_ICON_NAME,
  OperationTextAnnotation.JSON_PROPERTY_HIDDEN,
  OperationTextAnnotation.JSON_PROPERTY_ICON,
  OperationTextAnnotation.JSON_PROPERTY_INITIAL_OPEN,
  OperationTextAnnotation.JSON_PROPERTY_INTENTS,
  OperationTextAnnotation.JSON_PROPERTY_INVISIBLE,
  OperationTextAnnotation.JSON_PROPERTY_LOCKED,
  OperationTextAnnotation.JSON_PROPERTY_NAME,
  OperationTextAnnotation.JSON_PROPERTY_NORMAL_APPEARANCE,
  OperationTextAnnotation.JSON_PROPERTY_OPACITY,
  OperationTextAnnotation.JSON_PROPERTY_PAGE,
  OperationTextAnnotation.JSON_PROPERTY_POSITION,
  OperationTextAnnotation.JSON_PROPERTY_PRINTABLE,
  OperationTextAnnotation.JSON_PROPERTY_ROTATABLE,
  OperationTextAnnotation.JSON_PROPERTY_SUBJECT,
  OperationTextAnnotation.JSON_PROPERTY_VIEWABLE,
  OperationTextAnnotation.JSON_PROPERTY_WRITABLE,
  OperationTextAnnotation.JSON_PROPERTY_ZOOMABLE
})
@JsonTypeName("Operation_TextAnnotation")

public class OperationTextAnnotation {
  /**
   * Determines for which named annotations appearance streams shall be generated.  **Important:** Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those.  *   always &#x3D; An appearance stream shall be prepared for all created named annotations. *   never &#x3D; Don&#39;t provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations. *   nonStandard &#x3D; Only provide appearance streams for non-standard annotations.
   */
  public enum AppearanceGenerationEnum {
    ALWAYS("Always"),
    
    NEVER("Never"),
    
    NONSTANDARD("nonStandard");

    private String value;

    AppearanceGenerationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AppearanceGenerationEnum fromValue(String value) {
      for (AppearanceGenerationEnum b : AppearanceGenerationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_APPEARANCE_GENERATION = "appearanceGeneration";
  private AppearanceGenerationEnum appearanceGeneration = AppearanceGenerationEnum.NONSTANDARD;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#4800FF";

  public static final String JSON_PROPERTY_CONTENTS = "contents";
  private String contents = "";

  public static final String JSON_PROPERTY_CREATOR = "creator";
  private String creator = "";

  public static final String JSON_PROPERTY_CUSTOM_ICON_NAME = "customIconName";
  private String customIconName = "";

  public static final String JSON_PROPERTY_HIDDEN = "hidden";
  private Boolean hidden = false;

  /**
   * Used to specify the icon that should be displayed for the note on the page. The following values are available:  *   check &#x3D; The text annotation approves the content. *   checkmark &#x3D; The text annotation adds a gray checkmark to the content. *   circle &#x3D; The text annotation is a comment on the circled content. *   comment &#x3D; The text annotation is a comment to the marked contents. *   cross &#x3D; The text annotation marks the content or crosses it out. *   crossHair &#x3D; The text annotation targets the content in the crosshair. *   insert &#x3D; The text annotation is suggesting inserting some content. *   key &#x3D; The text annotation marks or contains a key content/information. *   note &#x3D; The text annotation is a mere note concerning the marked content. *   help &#x3D; The text annotation provides helpful information concerning the marked content. *   newParagraph &#x3D; The text annotation suggests adding a new Paragraph at a specific point. *   paragraph &#x3D; The text annotation is concerning the whole paragraph. *   rightArrow &#x3D; The text annotation is concerning the content to the right. *   rightPointer &#x3D; The text annotation is concerning the content to the right. *   star &#x3D; The text annotation marks content as especially important. *   upArrow &#x3D; The text annotation is concerning the content at the top. *   upLeftArrow &#x3D; The text annotation is concerning the content at the top left. *   unnamed &#x3D; The text annotation shall not provide a predefined name.
   */
  public enum IconEnum {
    CHECK("check"),
    
    CHECKMARK("checkmark"),
    
    CIRCLE("circle"),
    
    COMMENT("comment"),
    
    CROSS("cross"),
    
    CROSSHAIR("crossHair"),
    
    INSERT("insert"),
    
    KEY("key"),
    
    NOTE("note"),
    
    HELP("help"),
    
    NEWPARAGRAPH("newParagraph"),
    
    PARAGRAPH("paragraph"),
    
    RIGHTARROW("rightArrow"),
    
    RIGHTPOINTER("rightPointer"),
    
    STAR("star"),
    
    UPARROW("upArrow"),
    
    UPLEFTARROW("upLeftArrow"),
    
    UNNAMED("unnamed");

    private String value;

    IconEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IconEnum fromValue(String value) {
      for (IconEnum b : IconEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ICON = "icon";
  private IconEnum icon = IconEnum.NOTE;

  public static final String JSON_PROPERTY_INITIAL_OPEN = "initialOpen";
  private Boolean initialOpen = true;

  public static final String JSON_PROPERTY_INTENTS = "intents";
  private String intents = "";

  public static final String JSON_PROPERTY_INVISIBLE = "invisible";
  private Boolean invisible = false;

  public static final String JSON_PROPERTY_LOCKED = "locked";
  private Boolean locked = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_NORMAL_APPEARANCE = "normalAppearance";
  private OperationAppearanceSource normalAppearance;

  public static final String JSON_PROPERTY_OPACITY = "opacity";
  private Integer opacity = 100;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 1;

  public static final String JSON_PROPERTY_POSITION = "position";
  private OperationRectangle position;

  public static final String JSON_PROPERTY_PRINTABLE = "printable";
  private Boolean printable = false;

  public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
  private Boolean rotatable = true;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject = "";

  public static final String JSON_PROPERTY_VIEWABLE = "viewable";
  private Boolean viewable = true;

  public static final String JSON_PROPERTY_WRITABLE = "writable";
  private Boolean writable = true;

  public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
  private Boolean zoomable = true;

  public OperationTextAnnotation() {
  }

  public OperationTextAnnotation appearanceGeneration(AppearanceGenerationEnum appearanceGeneration) {
    
    this.appearanceGeneration = appearanceGeneration;
    return this;
  }

  /**
   * Determines for which named annotations appearance streams shall be generated.  **Important:** Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those.  *   always &#x3D; An appearance stream shall be prepared for all created named annotations. *   never &#x3D; Don&#39;t provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations. *   nonStandard &#x3D; Only provide appearance streams for non-standard annotations.
   * @return appearanceGeneration
   **/
  @Nullable
  @Schema(name = "Determines for which named annotations appearance streams shall be generated.  **Important:** Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those.  *   always = An appearance stream shall be prepared for all created named annotations. *   never = Don't provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations. *   nonStandard = Only provide appearance streams for non-standard annotations.")
  @JsonProperty(JSON_PROPERTY_APPEARANCE_GENERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AppearanceGenerationEnum getAppearanceGeneration() {
    return appearanceGeneration;
  }


  @JsonProperty(JSON_PROPERTY_APPEARANCE_GENERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppearanceGeneration(AppearanceGenerationEnum appearanceGeneration) {
    this.appearanceGeneration = appearanceGeneration;
  }


  public OperationTextAnnotation color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.
   * @return color
   **/
  @Nullable
  @Schema(name = "The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public OperationTextAnnotation contents(String contents) {
    
    this.contents = contents;
    return this;
  }

  /**
   * This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation&#39;s popup).
   * @return contents
   **/
  @Nullable
  @Schema(name = "This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).")
  @JsonProperty(JSON_PROPERTY_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContents() {
    return contents;
  }


  @JsonProperty(JSON_PROPERTY_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContents(String contents) {
    this.contents = contents;
  }


  public OperationTextAnnotation creator(String creator) {
    
    this.creator = creator;
    return this;
  }

  /**
   * Used to specify the author of the annotation.
   * @return creator
   **/
  @Nullable
  @Schema(name = "Used to specify the author of the annotation.")
  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreator() {
    return creator;
  }


  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreator(String creator) {
    this.creator = creator;
  }


  public OperationTextAnnotation customIconName(String customIconName) {
    
    this.customIconName = customIconName;
    return this;
  }

  /**
   * Sets a custom icon name for this annotation.  **Important:** This name shall always take precedence over possibly set standard names. (icon)
   * @return customIconName
   **/
  @Nullable
  @Schema(name = "Sets a custom icon name for this annotation.  **Important:** This name shall always take precedence over possibly set standard names. (icon)")
  @JsonProperty(JSON_PROPERTY_CUSTOM_ICON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomIconName() {
    return customIconName;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_ICON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomIconName(String customIconName) {
    this.customIconName = customIconName;
  }


  public OperationTextAnnotation hidden(Boolean hidden) {
    
    this.hidden = hidden;
    return this;
  }

  /**
   * If this value is set to true, the annotation will not be shown on the page and will not be printed either.
   * @return hidden
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
  @JsonProperty(JSON_PROPERTY_HIDDEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHidden() {
    return hidden;
  }


  @JsonProperty(JSON_PROPERTY_HIDDEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHidden(Boolean hidden) {
    this.hidden = hidden;
  }


  public OperationTextAnnotation icon(IconEnum icon) {
    
    this.icon = icon;
    return this;
  }

  /**
   * Used to specify the icon that should be displayed for the note on the page. The following values are available:  *   check &#x3D; The text annotation approves the content. *   checkmark &#x3D; The text annotation adds a gray checkmark to the content. *   circle &#x3D; The text annotation is a comment on the circled content. *   comment &#x3D; The text annotation is a comment to the marked contents. *   cross &#x3D; The text annotation marks the content or crosses it out. *   crossHair &#x3D; The text annotation targets the content in the crosshair. *   insert &#x3D; The text annotation is suggesting inserting some content. *   key &#x3D; The text annotation marks or contains a key content/information. *   note &#x3D; The text annotation is a mere note concerning the marked content. *   help &#x3D; The text annotation provides helpful information concerning the marked content. *   newParagraph &#x3D; The text annotation suggests adding a new Paragraph at a specific point. *   paragraph &#x3D; The text annotation is concerning the whole paragraph. *   rightArrow &#x3D; The text annotation is concerning the content to the right. *   rightPointer &#x3D; The text annotation is concerning the content to the right. *   star &#x3D; The text annotation marks content as especially important. *   upArrow &#x3D; The text annotation is concerning the content at the top. *   upLeftArrow &#x3D; The text annotation is concerning the content at the top left. *   unnamed &#x3D; The text annotation shall not provide a predefined name.
   * @return icon
   **/
  @Nullable
  @Schema(name = "Used to specify the icon that should be displayed for the note on the page. The following values are available:  *   check = The text annotation approves the content. *   checkmark = The text annotation adds a gray checkmark to the content. *   circle = The text annotation is a comment on the circled content. *   comment = The text annotation is a comment to the marked contents. *   cross = The text annotation marks the content or crosses it out. *   crossHair = The text annotation targets the content in the crosshair. *   insert = The text annotation is suggesting inserting some content. *   key = The text annotation marks or contains a key content/information. *   note = The text annotation is a mere note concerning the marked content. *   help = The text annotation provides helpful information concerning the marked content. *   newParagraph = The text annotation suggests adding a new Paragraph at a specific point. *   paragraph = The text annotation is concerning the whole paragraph. *   rightArrow = The text annotation is concerning the content to the right. *   rightPointer = The text annotation is concerning the content to the right. *   star = The text annotation marks content as especially important. *   upArrow = The text annotation is concerning the content at the top. *   upLeftArrow = The text annotation is concerning the content at the top left. *   unnamed = The text annotation shall not provide a predefined name.")
  @JsonProperty(JSON_PROPERTY_ICON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IconEnum getIcon() {
    return icon;
  }


  @JsonProperty(JSON_PROPERTY_ICON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIcon(IconEnum icon) {
    this.icon = icon;
  }


  public OperationTextAnnotation initialOpen(Boolean initialOpen) {
    
    this.initialOpen = initialOpen;
    return this;
  }

  /**
   * If this value is set to \&quot;true,\&quot; the popup for the corresponding \&quot;note\&quot; annotation will be opened as soon as the corresponding document page is viewed.
   * @return initialOpen
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true,\" the popup for the corresponding \"note\" annotation will be opened as soon as the corresponding document page is viewed.")
  @JsonProperty(JSON_PROPERTY_INITIAL_OPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInitialOpen() {
    return initialOpen;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_OPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialOpen(Boolean initialOpen) {
    this.initialOpen = initialOpen;
  }


  public OperationTextAnnotation intents(String intents) {
    
    this.intents = intents;
    return this;
  }

  /**
   * Used to set the intention of the annotation.  **Important:** The intention of an annotation can directly influence it&#39;s behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.
   * @return intents
   **/
  @Nullable
  @Schema(name = "Used to set the intention of the annotation.  **Important:** The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.")
  @JsonProperty(JSON_PROPERTY_INTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIntents() {
    return intents;
  }


  @JsonProperty(JSON_PROPERTY_INTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIntents(String intents) {
    this.intents = intents;
  }


  public OperationTextAnnotation invisible(Boolean invisible) {
    
    this.invisible = invisible;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.
   * @return invisible
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
  @JsonProperty(JSON_PROPERTY_INVISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInvisible() {
    return invisible;
  }


  @JsonProperty(JSON_PROPERTY_INVISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvisible(Boolean invisible) {
    this.invisible = invisible;
  }


  public OperationTextAnnotation locked(Boolean locked) {
    
    this.locked = locked;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be locked so that no changes can be made to it.
   * @return locked
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be locked so that no changes can be made to it.")
  @JsonProperty(JSON_PROPERTY_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLocked() {
    return locked;
  }


  @JsonProperty(JSON_PROPERTY_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocked(Boolean locked) {
    this.locked = locked;
  }


  public OperationTextAnnotation name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Used to specify the name of the annotation.
   * @return name
   **/
  @Nullable
  @Schema(name = "Used to specify the name of the annotation.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public OperationTextAnnotation normalAppearance(OperationAppearanceSource normalAppearance) {
    
    this.normalAppearance = normalAppearance;
    return this;
  }

  /**
   * Get normalAppearance
   * @return normalAppearance
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_NORMAL_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationAppearanceSource getNormalAppearance() {
    return normalAppearance;
  }


  @JsonProperty(JSON_PROPERTY_NORMAL_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNormalAppearance(OperationAppearanceSource normalAppearance) {
    this.normalAppearance = normalAppearance;
  }


  public OperationTextAnnotation opacity(Integer opacity) {
    
    this.opacity = opacity;
    return this;
  }

  /**
   * This percentage value is used to set the annotation&#39;s transparency.
   * minimum: 0
   * maximum: 100
   * @return opacity
   **/
  @Nullable
  @Schema(name = "This percentage value is used to set the annotation's transparency.")
  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOpacity() {
    return opacity;
  }


  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }


  public OperationTextAnnotation page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * Set the number of the page, the annotation shall be placed on.
   * minimum: 1
   * @return page
   **/
  @Nullable
  @Schema(name = "Set the number of the page, the annotation shall be placed on.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public OperationTextAnnotation position(OperationRectangle position) {
    
    this.position = position;
    return this;
  }

  /**
   * Get position
   * @return position
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationRectangle getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(OperationRectangle position) {
    this.position = position;
  }


  public OperationTextAnnotation printable(Boolean printable) {
    
    this.printable = printable;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be included when the page is printed out.
   * @return printable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be included when the page is printed out.")
  @JsonProperty(JSON_PROPERTY_PRINTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPrintable() {
    return printable;
  }


  @JsonProperty(JSON_PROPERTY_PRINTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintable(Boolean printable) {
    this.printable = printable;
  }


  public OperationTextAnnotation rotatable(Boolean rotatable) {
    
    this.rotatable = rotatable;
    return this;
  }

  /**
   * If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.
   * @return rotatable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
  @JsonProperty(JSON_PROPERTY_ROTATABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRotatable() {
    return rotatable;
  }


  @JsonProperty(JSON_PROPERTY_ROTATABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotatable(Boolean rotatable) {
    this.rotatable = rotatable;
  }


  public OperationTextAnnotation subject(String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Used to specify the subject of the annotation.
   * @return subject
   **/
  @Nullable
  @Schema(name = "Used to specify the subject of the annotation.")
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public OperationTextAnnotation viewable(Boolean viewable) {
    
    this.viewable = viewable;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be shown on the document&#39;s page.
   * @return viewable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be shown on the document's page.")
  @JsonProperty(JSON_PROPERTY_VIEWABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getViewable() {
    return viewable;
  }


  @JsonProperty(JSON_PROPERTY_VIEWABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewable(Boolean viewable) {
    this.viewable = viewable;
  }


  public OperationTextAnnotation writable(Boolean writable) {
    
    this.writable = writable;
    return this;
  }

  /**
   * If this value is set to true, it will be possible to change the annotation&#39;s contents later on.
   * @return writable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, it will be possible to change the annotation's contents later on.")
  @JsonProperty(JSON_PROPERTY_WRITABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getWritable() {
    return writable;
  }


  @JsonProperty(JSON_PROPERTY_WRITABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWritable(Boolean writable) {
    this.writable = writable;
  }


  public OperationTextAnnotation zoomable(Boolean zoomable) {
    
    this.zoomable = zoomable;
    return this;
  }

  /**
   * If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.
   * @return zoomable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getZoomable() {
    return zoomable;
  }


  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoomable(Boolean zoomable) {
    this.zoomable = zoomable;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationTextAnnotation operationTextAnnotation = (OperationTextAnnotation) o;
    return Objects.equals(this.appearanceGeneration, operationTextAnnotation.appearanceGeneration) &&
        Objects.equals(this.color, operationTextAnnotation.color) &&
        Objects.equals(this.contents, operationTextAnnotation.contents) &&
        Objects.equals(this.creator, operationTextAnnotation.creator) &&
        Objects.equals(this.customIconName, operationTextAnnotation.customIconName) &&
        Objects.equals(this.hidden, operationTextAnnotation.hidden) &&
        Objects.equals(this.icon, operationTextAnnotation.icon) &&
        Objects.equals(this.initialOpen, operationTextAnnotation.initialOpen) &&
        Objects.equals(this.intents, operationTextAnnotation.intents) &&
        Objects.equals(this.invisible, operationTextAnnotation.invisible) &&
        Objects.equals(this.locked, operationTextAnnotation.locked) &&
        Objects.equals(this.name, operationTextAnnotation.name) &&
        Objects.equals(this.normalAppearance, operationTextAnnotation.normalAppearance) &&
        Objects.equals(this.opacity, operationTextAnnotation.opacity) &&
        Objects.equals(this.page, operationTextAnnotation.page) &&
        Objects.equals(this.position, operationTextAnnotation.position) &&
        Objects.equals(this.printable, operationTextAnnotation.printable) &&
        Objects.equals(this.rotatable, operationTextAnnotation.rotatable) &&
        Objects.equals(this.subject, operationTextAnnotation.subject) &&
        Objects.equals(this.viewable, operationTextAnnotation.viewable) &&
        Objects.equals(this.writable, operationTextAnnotation.writable) &&
        Objects.equals(this.zoomable, operationTextAnnotation.zoomable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appearanceGeneration, color, contents, creator, customIconName, hidden, icon, initialOpen, intents, invisible, locked, name, normalAppearance, opacity, page, position, printable, rotatable, subject, viewable, writable, zoomable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationTextAnnotation {\n");
    sb.append("    appearanceGeneration: ").append(toIndentedString(appearanceGeneration)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    contents: ").append(toIndentedString(contents)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    customIconName: ").append(toIndentedString(customIconName)).append("\n");
    sb.append("    hidden: ").append(toIndentedString(hidden)).append("\n");
    sb.append("    icon: ").append(toIndentedString(icon)).append("\n");
    sb.append("    initialOpen: ").append(toIndentedString(initialOpen)).append("\n");
    sb.append("    intents: ").append(toIndentedString(intents)).append("\n");
    sb.append("    invisible: ").append(toIndentedString(invisible)).append("\n");
    sb.append("    locked: ").append(toIndentedString(locked)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    normalAppearance: ").append(toIndentedString(normalAppearance)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    printable: ").append(toIndentedString(printable)).append("\n");
    sb.append("    rotatable: ").append(toIndentedString(rotatable)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    viewable: ").append(toIndentedString(viewable)).append("\n");
    sb.append("    writable: ").append(toIndentedString(writable)).append("\n");
    sb.append("    zoomable: ").append(toIndentedString(zoomable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
