/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to set the position of the watermark in the PDF document.
 */
@Schema(description = "Used to set the position of the watermark in the PDF document.")
@JsonPropertyOrder({
  OperationWatermarkPosition.JSON_PROPERTY_ASPECT_RATIO,
  OperationWatermarkPosition.JSON_PROPERTY_HEIGHT,
  OperationWatermarkPosition.JSON_PROPERTY_METRICS,
  OperationWatermarkPosition.JSON_PROPERTY_POSITION,
  OperationWatermarkPosition.JSON_PROPERTY_WIDTH,
  OperationWatermarkPosition.JSON_PROPERTY_X,
  OperationWatermarkPosition.JSON_PROPERTY_Y
})
@JsonTypeName("Operation_WatermarkPosition")

public class OperationWatermarkPosition {
  public static final String JSON_PROPERTY_ASPECT_RATIO = "aspectRatio";
  private Boolean aspectRatio = true;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height = 0;

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   */
  public enum MetricsEnum {
    PT("pt"),
    
    PC("pc"),
    
    PX("px"),
    
    MM("mm"),
    
    IN("in");

    private String value;

    MetricsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MetricsEnum fromValue(String value) {
      for (MetricsEnum b : MetricsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private MetricsEnum metrics = MetricsEnum.MM;

  /**
   * Uses one of multiple preset positions in order to position the watermark on the page.  *   custom &#x3D; Disable the use of a preset position. *   top\\_left &#x3D; Positions the watermark in the upper left corner. *   top\\_center &#x3D; Positions the watermark in the centre at the top margin. *   top\\_right &#x3D; Positions the watermark in the top right corner. *   center\\_left &#x3D; Positions the watermark at the centre of the page, to the left. *   center\\_center &#x3D; Positions the watermark at the centre of the page. *   center\\_right &#x3D; Positions the watermark at the centre of the page, to the right. *   bottom\\_left &#x3D; Positions the watermark in the bottom left corner. *   bottom\\_center &#x3D; Positions the watermark in the centre at the bottom margin. *   bottom\\_right &#x3D; Positions the watermark in the bottom right corner.
   */
  public enum PositionEnum {
    CUSTOM("custom"),
    
    TOP_LEFT("top_left"),
    
    TOP_CENTER("top_center"),
    
    TOP_RIGHT("top_right"),
    
    CENTER_LEFT("center_left"),
    
    CENTER_CENTER("center_center"),
    
    CENTER_RIGHT("center_right"),
    
    BOTTOM_LEFT("bottom_left"),
    
    BOTTOM_CENTER("bottom_center"),
    
    BOTTOM_RIGHT("bottom_right");

    private String value;

    PositionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PositionEnum fromValue(String value) {
      for (PositionEnum b : PositionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_POSITION = "position";
  private PositionEnum position = PositionEnum.CENTER_CENTER;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width = 0;

  public static final String JSON_PROPERTY_X = "x";
  private Integer x = 0;

  public static final String JSON_PROPERTY_Y = "y";
  private Integer y = 0;

  public OperationWatermarkPosition() {
  }

  public OperationWatermarkPosition aspectRatio(Boolean aspectRatio) {
    
    this.aspectRatio = aspectRatio;
    return this;
  }

  /**
   * Forces the aspect ratio to be maintained when a watermark is scaled if \&quot;width\&quot; and \&quot;height\&quot; are specified.
   * @return aspectRatio
   **/
  @Nullable
  @Schema(name = "Forces the aspect ratio to be maintained when a watermark is scaled if \"width\" and \"height\" are specified.")
  @JsonProperty(JSON_PROPERTY_ASPECT_RATIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAspectRatio() {
    return aspectRatio;
  }


  @JsonProperty(JSON_PROPERTY_ASPECT_RATIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAspectRatio(Boolean aspectRatio) {
    this.aspectRatio = aspectRatio;
  }


  public OperationWatermarkPosition height(Integer height) {
    
    this.height = height;
    return this;
  }

  /**
   * Forces the specified height for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to \&quot;aspectRatio\&quot; as well)
   * minimum: 0
   * @return height
   **/
  @Nullable
  @Schema(name = "Forces the specified height for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to \"aspectRatio\" as well)")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public OperationWatermarkPosition metrics(MetricsEnum metrics) {
    
    this.metrics = metrics;
    return this;
  }

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   * @return metrics
   **/
  @Nullable
  @Schema(name = "Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetricsEnum getMetrics() {
    return metrics;
  }


  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetrics(MetricsEnum metrics) {
    this.metrics = metrics;
  }


  public OperationWatermarkPosition position(PositionEnum position) {
    
    this.position = position;
    return this;
  }

  /**
   * Uses one of multiple preset positions in order to position the watermark on the page.  *   custom &#x3D; Disable the use of a preset position. *   top\\_left &#x3D; Positions the watermark in the upper left corner. *   top\\_center &#x3D; Positions the watermark in the centre at the top margin. *   top\\_right &#x3D; Positions the watermark in the top right corner. *   center\\_left &#x3D; Positions the watermark at the centre of the page, to the left. *   center\\_center &#x3D; Positions the watermark at the centre of the page. *   center\\_right &#x3D; Positions the watermark at the centre of the page, to the right. *   bottom\\_left &#x3D; Positions the watermark in the bottom left corner. *   bottom\\_center &#x3D; Positions the watermark in the centre at the bottom margin. *   bottom\\_right &#x3D; Positions the watermark in the bottom right corner.
   * @return position
   **/
  @Nullable
  @Schema(name = "Uses one of multiple preset positions in order to position the watermark on the page.  *   custom = Disable the use of a preset position. *   top\\_left = Positions the watermark in the upper left corner. *   top\\_center = Positions the watermark in the centre at the top margin. *   top\\_right = Positions the watermark in the top right corner. *   center\\_left = Positions the watermark at the centre of the page, to the left. *   center\\_center = Positions the watermark at the centre of the page. *   center\\_right = Positions the watermark at the centre of the page, to the right. *   bottom\\_left = Positions the watermark in the bottom left corner. *   bottom\\_center = Positions the watermark in the centre at the bottom margin. *   bottom\\_right = Positions the watermark in the bottom right corner.")
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PositionEnum getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(PositionEnum position) {
    this.position = position;
  }


  public OperationWatermarkPosition width(Integer width) {
    
    this.width = width;
    return this;
  }

  /**
   * Forces the specified width for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to \&quot;aspectRatio\&quot; as well)
   * minimum: 0
   * @return width
   **/
  @Nullable
  @Schema(name = "Forces the specified width for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to \"aspectRatio\" as well)")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  public OperationWatermarkPosition x(Integer x) {
    
    this.x = x;
    return this;
  }

  /**
   * Used to define the X-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to \&quot;custom.\&quot;. If \&quot;position is set to a different value, these arguments will be interpreted as \&quot;offsets\&quot; from the selected position. This specification applies for both the text and image output.
   * minimum: 0
   * @return x
   **/
  @Nullable
  @Schema(name = "Used to define the X-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to \"custom.\". If \"position is set to a different value, these arguments will be interpreted as \"offsets\" from the selected position. This specification applies for both the text and image output.")
  @JsonProperty(JSON_PROPERTY_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getX() {
    return x;
  }


  @JsonProperty(JSON_PROPERTY_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setX(Integer x) {
    this.x = x;
  }


  public OperationWatermarkPosition y(Integer y) {
    
    this.y = y;
    return this;
  }

  /**
   * Used to define the Y-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to \&quot;custom.\&quot;. If \&quot;position is set to a different value, these arguments will be interpreted as \&quot;offsets\&quot; from the selected position. This specification applies for both the text and image output.
   * minimum: 0
   * @return y
   **/
  @Nullable
  @Schema(name = "Used to define the Y-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to \"custom.\". If \"position is set to a different value, these arguments will be interpreted as \"offsets\" from the selected position. This specification applies for both the text and image output.")
  @JsonProperty(JSON_PROPERTY_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getY() {
    return y;
  }


  @JsonProperty(JSON_PROPERTY_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setY(Integer y) {
    this.y = y;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationWatermarkPosition operationWatermarkPosition = (OperationWatermarkPosition) o;
    return Objects.equals(this.aspectRatio, operationWatermarkPosition.aspectRatio) &&
        Objects.equals(this.height, operationWatermarkPosition.height) &&
        Objects.equals(this.metrics, operationWatermarkPosition.metrics) &&
        Objects.equals(this.position, operationWatermarkPosition.position) &&
        Objects.equals(this.width, operationWatermarkPosition.width) &&
        Objects.equals(this.x, operationWatermarkPosition.x) &&
        Objects.equals(this.y, operationWatermarkPosition.y);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aspectRatio, height, metrics, position, width, x, y);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationWatermarkPosition {\n");
    sb.append("    aspectRatio: ").append(toIndentedString(aspectRatio)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    x: ").append(toIndentedString(x)).append("\n");
    sb.append("    y: ").append(toIndentedString(y)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
