/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines settings for an SSL (TLS) connector.
 */
@Schema(description = "Defines settings for an SSL (TLS) connector.")
@JsonPropertyOrder({
  ServerConfigSSL.JSON_PROPERTY_CIPHERS,
  ServerConfigSSL.JSON_PROPERTY_CLIENT_AUTH,
  ServerConfigSSL.JSON_PROPERTY_CONFIGURATION,
  ServerConfigSSL.JSON_PROPERTY_KEYSTORE,
  ServerConfigSSL.JSON_PROPERTY_MAX_THREADS,
  ServerConfigSSL.JSON_PROPERTY_PROTOCOLS,
  ServerConfigSSL.JSON_PROPERTY_SCHEME,
  ServerConfigSSL.JSON_PROPERTY_SESSION_CACHE_SIZE,
  ServerConfigSSL.JSON_PROPERTY_SESSION_TIMEOUT,
  ServerConfigSSL.JSON_PROPERTY_TRUSTSTORE
})
@JsonTypeName("ServerConfig_SSL")

public class ServerConfigSSL {
  public static final String JSON_PROPERTY_CIPHERS = "ciphers";
  private ServerConfigCiphersSSL ciphers;

  public static final String JSON_PROPERTY_CLIENT_AUTH = "clientAuth";
  private Boolean clientAuth = false;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private ServerConfigConnectorConfiguration _configuration;

  public static final String JSON_PROPERTY_KEYSTORE = "keystore";
  private ServerConfigKeystoreSSL keystore;

  public static final String JSON_PROPERTY_MAX_THREADS = "maxThreads";
  private Integer maxThreads = 150;

  public static final String JSON_PROPERTY_PROTOCOLS = "protocols";
  private ServerConfigProtocolsSSL protocols;

  public static final String JSON_PROPERTY_SCHEME = "scheme";
  private String scheme = "https";

  public static final String JSON_PROPERTY_SESSION_CACHE_SIZE = "sessionCacheSize";
  private Integer sessionCacheSize = 0;

  public static final String JSON_PROPERTY_SESSION_TIMEOUT = "sessionTimeout";
  private Integer sessionTimeout = 86400;

  public static final String JSON_PROPERTY_TRUSTSTORE = "truststore";
  private ServerConfigKeystore truststore;

  public ServerConfigSSL() {
  }

  public ServerConfigSSL ciphers(ServerConfigCiphersSSL ciphers) {
    
    this.ciphers = ciphers;
    return this;
  }

  /**
   * Get ciphers
   * @return ciphers
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CIPHERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigCiphersSSL getCiphers() {
    return ciphers;
  }


  @JsonProperty(JSON_PROPERTY_CIPHERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCiphers(ServerConfigCiphersSSL ciphers) {
    this.ciphers = ciphers;
  }


  public ServerConfigSSL clientAuth(Boolean clientAuth) {
    
    this.clientAuth = clientAuth;
    return this;
  }

  /**
   * Whether a client must provide a valid certificate before being accepted by the connector.
   * @return clientAuth
   **/
  @Nullable
  @Schema(name = "Whether a client must provide a valid certificate before being accepted by the connector.")
  @JsonProperty(JSON_PROPERTY_CLIENT_AUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClientAuth() {
    return clientAuth;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_AUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientAuth(Boolean clientAuth) {
    this.clientAuth = clientAuth;
  }


  public ServerConfigSSL _configuration(ServerConfigConnectorConfiguration _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

  /**
   * Get _configuration
   * @return _configuration
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigConnectorConfiguration getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(ServerConfigConnectorConfiguration _configuration) {
    this._configuration = _configuration;
  }


  public ServerConfigSSL keystore(ServerConfigKeystoreSSL keystore) {
    
    this.keystore = keystore;
    return this;
  }

  /**
   * Get keystore
   * @return keystore
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_KEYSTORE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServerConfigKeystoreSSL getKeystore() {
    return keystore;
  }


  @JsonProperty(JSON_PROPERTY_KEYSTORE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeystore(ServerConfigKeystoreSSL keystore) {
    this.keystore = keystore;
  }


  public ServerConfigSSL maxThreads(Integer maxThreads) {
    
    this.maxThreads = maxThreads;
    return this;
  }

  /**
   * The maximum number of request processing threads created by this connector.
   * minimum: 1
   * @return maxThreads
   **/
  @Nullable
  @Schema(name = "The maximum number of request processing threads created by this connector.")
  @JsonProperty(JSON_PROPERTY_MAX_THREADS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxThreads() {
    return maxThreads;
  }


  @JsonProperty(JSON_PROPERTY_MAX_THREADS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxThreads(Integer maxThreads) {
    this.maxThreads = maxThreads;
  }


  public ServerConfigSSL protocols(ServerConfigProtocolsSSL protocols) {
    
    this.protocols = protocols;
    return this;
  }

  /**
   * Get protocols
   * @return protocols
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_PROTOCOLS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServerConfigProtocolsSSL getProtocols() {
    return protocols;
  }


  @JsonProperty(JSON_PROPERTY_PROTOCOLS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProtocols(ServerConfigProtocolsSSL protocols) {
    this.protocols = protocols;
  }


  public ServerConfigSSL scheme(String scheme) {
    
    this.scheme = scheme;
    return this;
  }

  /**
   * The TLS connection scheme. (e.g. \&quot;https\&quot;)
   * @return scheme
   **/
  @Nullable
  @Schema(name = "The TLS connection scheme. (e.g. \"https\")")
  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScheme() {
    return scheme;
  }


  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheme(String scheme) {
    this.scheme = scheme;
  }


  public ServerConfigSSL sessionCacheSize(Integer sessionCacheSize) {
    
    this.sessionCacheSize = sessionCacheSize;
    return this;
  }

  /**
   * The number of SSL sessions to maintain in the session cache.
   * minimum: 0
   * @return sessionCacheSize
   **/
  @Nullable
  @Schema(name = "The number of SSL sessions to maintain in the session cache.")
  @JsonProperty(JSON_PROPERTY_SESSION_CACHE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSessionCacheSize() {
    return sessionCacheSize;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_CACHE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionCacheSize(Integer sessionCacheSize) {
    this.sessionCacheSize = sessionCacheSize;
  }


  public ServerConfigSSL sessionTimeout(Integer sessionTimeout) {
    
    this.sessionTimeout = sessionTimeout;
    return this;
  }

  /**
   * The time in seconds before a session is encountering it&#39;s timeout.
   * minimum: 0
   * @return sessionTimeout
   **/
  @Nullable
  @Schema(name = "The time in seconds before a session is encountering it's timeout.")
  @JsonProperty(JSON_PROPERTY_SESSION_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSessionTimeout() {
    return sessionTimeout;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionTimeout(Integer sessionTimeout) {
    this.sessionTimeout = sessionTimeout;
  }


  public ServerConfigSSL truststore(ServerConfigKeystore truststore) {
    
    this.truststore = truststore;
    return this;
  }

  /**
   * Get truststore
   * @return truststore
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TRUSTSTORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigKeystore getTruststore() {
    return truststore;
  }


  @JsonProperty(JSON_PROPERTY_TRUSTSTORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTruststore(ServerConfigKeystore truststore) {
    this.truststore = truststore;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigSSL serverConfigSSL = (ServerConfigSSL) o;
    return Objects.equals(this.ciphers, serverConfigSSL.ciphers) &&
        Objects.equals(this.clientAuth, serverConfigSSL.clientAuth) &&
        Objects.equals(this._configuration, serverConfigSSL._configuration) &&
        Objects.equals(this.keystore, serverConfigSSL.keystore) &&
        Objects.equals(this.maxThreads, serverConfigSSL.maxThreads) &&
        Objects.equals(this.protocols, serverConfigSSL.protocols) &&
        Objects.equals(this.scheme, serverConfigSSL.scheme) &&
        Objects.equals(this.sessionCacheSize, serverConfigSSL.sessionCacheSize) &&
        Objects.equals(this.sessionTimeout, serverConfigSSL.sessionTimeout) &&
        Objects.equals(this.truststore, serverConfigSSL.truststore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ciphers, clientAuth, _configuration, keystore, maxThreads, protocols, scheme, sessionCacheSize, sessionTimeout, truststore);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigSSL {\n");
    sb.append("    ciphers: ").append(toIndentedString(ciphers)).append("\n");
    sb.append("    clientAuth: ").append(toIndentedString(clientAuth)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    keystore: ").append(toIndentedString(keystore)).append("\n");
    sb.append("    maxThreads: ").append(toIndentedString(maxThreads)).append("\n");
    sb.append("    protocols: ").append(toIndentedString(protocols)).append("\n");
    sb.append("    scheme: ").append(toIndentedString(scheme)).append("\n");
    sb.append("    sessionCacheSize: ").append(toIndentedString(sessionCacheSize)).append("\n");
    sb.append("    sessionTimeout: ").append(toIndentedString(sessionTimeout)).append("\n");
    sb.append("    truststore: ").append(toIndentedString(truststore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
