/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines settings for the server&#39;s user storage.
 */
@Schema(description = "Defines settings for the server's user storage.")
@JsonPropertyOrder({
  ServerConfigUserStorage.JSON_PROPERTY_AZURE_AD,
  ServerConfigUserStorage.JSON_PROPERTY_DB,
  ServerConfigUserStorage.JSON_PROPERTY_LDAP,
  ServerConfigUserStorage.JSON_PROPERTY_ROLE_ADMIN_GROUP,
  ServerConfigUserStorage.JSON_PROPERTY_ROLE_USER_GROUP,
  ServerConfigUserStorage.JSON_PROPERTY_XML
})
@JsonTypeName("ServerConfig_UserStorage")

public class ServerConfigUserStorage {
  public static final String JSON_PROPERTY_AZURE_AD = "azureAd";
  private ServerConfigUserAzureAd azureAd;

  public static final String JSON_PROPERTY_DB = "db";
  private ServerConfigUserDb db;

  public static final String JSON_PROPERTY_LDAP = "ldap";
  private ServerConfigUserLdap ldap;

  public static final String JSON_PROPERTY_ROLE_ADMIN_GROUP = "roleAdminGroup";
  private String roleAdminGroup = "admin";

  public static final String JSON_PROPERTY_ROLE_USER_GROUP = "roleUserGroup";
  private String roleUserGroup = "user";

  public static final String JSON_PROPERTY_XML = "xml";
  private Object xml;

  public ServerConfigUserStorage() {
  }

  public ServerConfigUserStorage azureAd(ServerConfigUserAzureAd azureAd) {
    
    this.azureAd = azureAd;
    return this;
  }

  /**
   * Get azureAd
   * @return azureAd
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_AZURE_AD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigUserAzureAd getAzureAd() {
    return azureAd;
  }


  @JsonProperty(JSON_PROPERTY_AZURE_AD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAzureAd(ServerConfigUserAzureAd azureAd) {
    this.azureAd = azureAd;
  }


  public ServerConfigUserStorage db(ServerConfigUserDb db) {
    
    this.db = db;
    return this;
  }

  /**
   * Get db
   * @return db
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigUserDb getDb() {
    return db;
  }


  @JsonProperty(JSON_PROPERTY_DB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDb(ServerConfigUserDb db) {
    this.db = db;
  }


  public ServerConfigUserStorage ldap(ServerConfigUserLdap ldap) {
    
    this.ldap = ldap;
    return this;
  }

  /**
   * Get ldap
   * @return ldap
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LDAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigUserLdap getLdap() {
    return ldap;
  }


  @JsonProperty(JSON_PROPERTY_LDAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLdap(ServerConfigUserLdap ldap) {
    this.ldap = ldap;
  }


  public ServerConfigUserStorage roleAdminGroup(String roleAdminGroup) {
    
    this.roleAdminGroup = roleAdminGroup;
    return this;
  }

  /**
   * Sets the name of the group that grants administrative rights to users. This allows replacing the default value \&quot;admin\&quot; with a user-defined group name. A user must be a member of the group to be granted administrative rights.
   * @return roleAdminGroup
   **/
  @Nullable
  @Schema(name = "Sets the name of the group that grants administrative rights to users. This allows replacing the default value \"admin\" with a user-defined group name. A user must be a member of the group to be granted administrative rights.")
  @JsonProperty(JSON_PROPERTY_ROLE_ADMIN_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleAdminGroup() {
    return roleAdminGroup;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_ADMIN_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleAdminGroup(String roleAdminGroup) {
    this.roleAdminGroup = roleAdminGroup;
  }


  public ServerConfigUserStorage roleUserGroup(String roleUserGroup) {
    
    this.roleUserGroup = roleUserGroup;
    return this;
  }

  /**
   * Sets the name of the group that grants normal user rights to users. This allows replacing the default \&quot;user\&quot; value with a custom group name. A user must be a member of the group to be granted normal user rights.
   * @return roleUserGroup
   **/
  @Nullable
  @Schema(name = "Sets the name of the group that grants normal user rights to users. This allows replacing the default \"user\" value with a custom group name. A user must be a member of the group to be granted normal user rights.")
  @JsonProperty(JSON_PROPERTY_ROLE_USER_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleUserGroup() {
    return roleUserGroup;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_USER_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleUserGroup(String roleUserGroup) {
    this.roleUserGroup = roleUserGroup;
  }


  public ServerConfigUserStorage xml(Object xml) {
    
    this.xml = xml;
    return this;
  }

  /**
   * Defines the local XML file \&quot;conf/users.xml\&quot; as the user source. The users are managed locally via the portal administration area.
   * @return xml
   **/
  @Nullable
  @Schema(name = "Defines the local XML file \"conf/users.xml\" as the user source. The users are managed locally via the portal administration area.")
  @JsonProperty(JSON_PROPERTY_XML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getXml() {
    return xml;
  }


  @JsonProperty(JSON_PROPERTY_XML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setXml(Object xml) {
    this.xml = xml;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigUserStorage serverConfigUserStorage = (ServerConfigUserStorage) o;
    return Objects.equals(this.azureAd, serverConfigUserStorage.azureAd) &&
        Objects.equals(this.db, serverConfigUserStorage.db) &&
        Objects.equals(this.ldap, serverConfigUserStorage.ldap) &&
        Objects.equals(this.roleAdminGroup, serverConfigUserStorage.roleAdminGroup) &&
        Objects.equals(this.roleUserGroup, serverConfigUserStorage.roleUserGroup) &&
        Objects.equals(this.xml, serverConfigUserStorage.xml);
  }

  @Override
  public int hashCode() {
    return Objects.hash(azureAd, db, ldap, roleAdminGroup, roleUserGroup, xml);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigUserStorage {\n");
    sb.append("    azureAd: ").append(toIndentedString(azureAd)).append("\n");
    sb.append("    db: ").append(toIndentedString(db)).append("\n");
    sb.append("    ldap: ").append(toIndentedString(ldap)).append("\n");
    sb.append("    roleAdminGroup: ").append(toIndentedString(roleAdminGroup)).append("\n");
    sb.append("    roleUserGroup: ").append(toIndentedString(roleUserGroup)).append("\n");
    sb.append("    xml: ").append(toIndentedString(xml)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
