
package net.webpdf.wsclient.schema.extraction.info;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An element of this type describes an Annotation placed on a page of the document.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for AnnotationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="AnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence minOccurs="0">
 *         <choice maxOccurs="unbounded" minOccurs="0">
 *           <element name="rectangle" type="{http://schema.webpdf.de/1.0/extraction/info}AnnotationRectangleType"/>
 *           <element name="point" type="{http://schema.webpdf.de/1.0/extraction/info}AnnotationPointType"/>
 *         </choice>
 *         <element name="markup" type="{http://schema.webpdf.de/1.0/extraction/info}MarkupType" minOccurs="0"/>
 *         <element name="popup" type="{http://schema.webpdf.de/1.0/extraction/info}PopupType" minOccurs="0"/>
 *         <element name="appearance" type="{http://schema.webpdf.de/1.0/extraction/info}AppearanceType" minOccurs="0"/>
 *         <element name="line" type="{http://schema.webpdf.de/1.0/extraction/info}LineType" minOccurs="0"/>
 *         <element name="border" type="{http://schema.webpdf.de/1.0/extraction/info}BorderStyle" minOccurs="0"/>
 *         <element name="drawStyle" type="{http://schema.webpdf.de/1.0/extraction/info}DrawStyleType" minOccurs="0"/>
 *       </sequence>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/extraction/info}FlagsAnnotationGroup"/>
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subType" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="contents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/extraction/info}RgbColorType" default="#4800FF" />
 *       <attribute name="rotation" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="iconName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AnnotationType", propOrder = {
    "positions",
    "markup",
    "popup",
    "appearance",
    "line",
    "border",
    "drawStyle"
})
public class AnnotationType {

    @XmlElements({
        @XmlElement(name = "rectangle", type = AnnotationRectangleType.class),
        @XmlElement(name = "point", type = AnnotationPointType.class)
    })
    protected List<PositionsType> positions;
    protected MarkupType markup;
    protected PopupType popup;
    protected AppearanceType appearance;
    protected LineType line;
    protected BorderStyle border;
    protected DrawStyleType drawStyle;
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    @XmlAttribute(name = "subType")
    protected String subType;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "contents")
    protected String contents;
    @XmlAttribute(name = "page")
    protected Integer page;
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;
    @XmlAttribute(name = "rotation")
    protected Integer rotation;
    @XmlAttribute(name = "iconName")
    protected String iconName;
    @XmlAttribute(name = "locked")
    protected Boolean locked;
    @XmlAttribute(name = "printable")
    protected Boolean printable;
    @XmlAttribute(name = "rotatable")
    protected Boolean rotatable;
    @XmlAttribute(name = "viewable")
    protected Boolean viewable;
    @XmlAttribute(name = "writable")
    protected Boolean writable;
    @XmlAttribute(name = "zoomable")
    protected Boolean zoomable;
    @XmlAttribute(name = "invisible")
    protected Boolean invisible;
    @XmlAttribute(name = "hidden")
    protected Boolean hidden;

    /**
     * Gets the value of the positions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the positions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPositions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AnnotationPointType }
     * {@link AnnotationRectangleType }
     * 
     * 
     * @return
     *     The value of the positions property.
     */
    public List<PositionsType> getPositions() {
        if (positions == null) {
            positions = new ArrayList<>();
        }
        return this.positions;
    }

    public boolean isSetPositions() {
        return ((this.positions!= null)&&(!this.positions.isEmpty()));
    }

    public void unsetPositions() {
        this.positions = null;
    }

    /**
     * Gets the value of the markup property.
     * 
     * @return
     *     possible object is
     *     {@link MarkupType }
     *     
     */
    public MarkupType getMarkup() {
        return markup;
    }

    /**
     * Sets the value of the markup property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkupType }
     *     
     */
    public void setMarkup(MarkupType value) {
        this.markup = value;
    }

    public boolean isSetMarkup() {
        return (this.markup!= null);
    }

    /**
     * Gets the value of the popup property.
     * 
     * @return
     *     possible object is
     *     {@link PopupType }
     *     
     */
    public PopupType getPopup() {
        return popup;
    }

    /**
     * Sets the value of the popup property.
     * 
     * @param value
     *     allowed object is
     *     {@link PopupType }
     *     
     */
    public void setPopup(PopupType value) {
        this.popup = value;
    }

    public boolean isSetPopup() {
        return (this.popup!= null);
    }

    /**
     * Gets the value of the appearance property.
     * 
     * @return
     *     possible object is
     *     {@link AppearanceType }
     *     
     */
    public AppearanceType getAppearance() {
        return appearance;
    }

    /**
     * Sets the value of the appearance property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceType }
     *     
     */
    public void setAppearance(AppearanceType value) {
        this.appearance = value;
    }

    public boolean isSetAppearance() {
        return (this.appearance!= null);
    }

    /**
     * Gets the value of the line property.
     * 
     * @return
     *     possible object is
     *     {@link LineType }
     *     
     */
    public LineType getLine() {
        return line;
    }

    /**
     * Sets the value of the line property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineType }
     *     
     */
    public void setLine(LineType value) {
        this.line = value;
    }

    public boolean isSetLine() {
        return (this.line!= null);
    }

    /**
     * Gets the value of the border property.
     * 
     * @return
     *     possible object is
     *     {@link BorderStyle }
     *     
     */
    public BorderStyle getBorder() {
        return border;
    }

    /**
     * Sets the value of the border property.
     * 
     * @param value
     *     allowed object is
     *     {@link BorderStyle }
     *     
     */
    public void setBorder(BorderStyle value) {
        this.border = value;
    }

    public boolean isSetBorder() {
        return (this.border!= null);
    }

    /**
     * Gets the value of the drawStyle property.
     * 
     * @return
     *     possible object is
     *     {@link DrawStyleType }
     *     
     */
    public DrawStyleType getDrawStyle() {
        return drawStyle;
    }

    /**
     * Sets the value of the drawStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link DrawStyleType }
     *     
     */
    public void setDrawStyle(DrawStyleType value) {
        this.drawStyle = value;
    }

    public boolean isSetDrawStyle() {
        return (this.drawStyle!= null);
    }

    /**
     * Gets the value of the objectKey property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    public boolean isSetObjectKey() {
        return (this.objectKey!= null);
    }

    /**
     * Gets the value of the subType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubType() {
        if (subType == null) {
            return "";
        } else {
            return subType;
        }
    }

    /**
     * Sets the value of the subType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSubType(String value) {
        this.subType = value;
    }

    public boolean isSetSubType() {
        return (this.subType!= null);
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * Gets the value of the contents property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContents() {
        if (contents == null) {
            return "";
        } else {
            return contents;
        }
    }

    /**
     * Sets the value of the contents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setContents(String value) {
        this.contents = value;
    }

    public boolean isSetContents() {
        return (this.contents!= null);
    }

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  0;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * Gets the value of the color property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#4800FF";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

    /**
     * Gets the value of the rotation property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRotation() {
        if (rotation == null) {
            return  0;
        } else {
            return rotation;
        }
    }

    /**
     * Sets the value of the rotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setRotation(int value) {
        this.rotation = value;
    }

    public boolean isSetRotation() {
        return (this.rotation!= null);
    }

    public void unsetRotation() {
        this.rotation = null;
    }

    /**
     * Gets the value of the iconName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIconName() {
        if (iconName == null) {
            return "";
        } else {
            return iconName;
        }
    }

    /**
     * Sets the value of the iconName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIconName(String value) {
        this.iconName = value;
    }

    public boolean isSetIconName() {
        return (this.iconName!= null);
    }

    /**
     * Gets the value of the locked property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLocked() {
        if (locked == null) {
            return true;
        } else {
            return locked;
        }
    }

    /**
     * Sets the value of the locked property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLocked(boolean value) {
        this.locked = value;
    }

    public boolean isSetLocked() {
        return (this.locked!= null);
    }

    public void unsetLocked() {
        this.locked = null;
    }

    /**
     * Gets the value of the printable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPrintable() {
        if (printable == null) {
            return false;
        } else {
            return printable;
        }
    }

    /**
     * Sets the value of the printable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrintable(boolean value) {
        this.printable = value;
    }

    public boolean isSetPrintable() {
        return (this.printable!= null);
    }

    public void unsetPrintable() {
        this.printable = null;
    }

    /**
     * Gets the value of the rotatable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRotatable() {
        if (rotatable == null) {
            return true;
        } else {
            return rotatable;
        }
    }

    /**
     * Sets the value of the rotatable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRotatable(boolean value) {
        this.rotatable = value;
    }

    public boolean isSetRotatable() {
        return (this.rotatable!= null);
    }

    public void unsetRotatable() {
        this.rotatable = null;
    }

    /**
     * Gets the value of the viewable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isViewable() {
        if (viewable == null) {
            return true;
        } else {
            return viewable;
        }
    }

    /**
     * Sets the value of the viewable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setViewable(boolean value) {
        this.viewable = value;
    }

    public boolean isSetViewable() {
        return (this.viewable!= null);
    }

    public void unsetViewable() {
        this.viewable = null;
    }

    /**
     * Gets the value of the writable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isWritable() {
        if (writable == null) {
            return true;
        } else {
            return writable;
        }
    }

    /**
     * Sets the value of the writable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setWritable(boolean value) {
        this.writable = value;
    }

    public boolean isSetWritable() {
        return (this.writable!= null);
    }

    public void unsetWritable() {
        this.writable = null;
    }

    /**
     * Gets the value of the zoomable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isZoomable() {
        if (zoomable == null) {
            return true;
        } else {
            return zoomable;
        }
    }

    /**
     * Sets the value of the zoomable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setZoomable(boolean value) {
        this.zoomable = value;
    }

    public boolean isSetZoomable() {
        return (this.zoomable!= null);
    }

    public void unsetZoomable() {
        this.zoomable = null;
    }

    /**
     * Gets the value of the invisible property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isInvisible() {
        if (invisible == null) {
            return false;
        } else {
            return invisible;
        }
    }

    /**
     * Sets the value of the invisible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInvisible(boolean value) {
        this.invisible = value;
    }

    public boolean isSetInvisible() {
        return (this.invisible!= null);
    }

    public void unsetInvisible() {
        this.invisible = null;
    }

    /**
     * Gets the value of the hidden property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHidden() {
        if (hidden == null) {
            return false;
        } else {
            return hidden;
        }
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHidden(boolean value) {
        this.hidden = value;
    }

    public boolean isSetHidden() {
        return (this.hidden!= null);
    }

    public void unsetHidden() {
        this.hidden = null;
    }

}
