
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects a border style for a drawn shape's outline.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for BorderStyle complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="BorderStyle">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="style" type="{http://www.w3.org/2001/XMLSchema}string" default="S" />
 *       <attribute name="width" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="dashPattern" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="dashPhase" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="effectStyle" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="effectIntensity" type="{http://www.w3.org/2001/XMLSchema}float" default="0" />
 *       <attribute name="interiorColor" type="{http://schema.webpdf.de/1.0/extraction/info}RgbColorType" default="#4800FF" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BorderStyle")
public class BorderStyle {

    @XmlAttribute(name = "style")
    protected String style;
    @XmlAttribute(name = "width")
    protected Float width;
    @XmlAttribute(name = "dashPattern")
    protected String dashPattern;
    @XmlAttribute(name = "dashPhase")
    protected Integer dashPhase;
    @XmlAttribute(name = "effectStyle")
    protected String effectStyle;
    @XmlAttribute(name = "effectIntensity")
    protected Float effectIntensity;
    @XmlAttribute(name = "interiorColor")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String interiorColor;

    /**
     * Gets the value of the style property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStyle() {
        if (style == null) {
            return "S";
        } else {
            return style;
        }
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStyle(String value) {
        this.style = value;
    }

    public boolean isSetStyle() {
        return (this.style!= null);
    }

    /**
     * Gets the value of the width property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getWidth() {
        if (width == null) {
            return  1.0F;
        } else {
            return width;
        }
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setWidth(float value) {
        this.width = value;
    }

    public boolean isSetWidth() {
        return (this.width!= null);
    }

    public void unsetWidth() {
        this.width = null;
    }

    /**
     * Gets the value of the dashPattern property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDashPattern() {
        if (dashPattern == null) {
            return "";
        } else {
            return dashPattern;
        }
    }

    /**
     * Sets the value of the dashPattern property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDashPattern(String value) {
        this.dashPattern = value;
    }

    public boolean isSetDashPattern() {
        return (this.dashPattern!= null);
    }

    /**
     * Gets the value of the dashPhase property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDashPhase() {
        if (dashPhase == null) {
            return  0;
        } else {
            return dashPhase;
        }
    }

    /**
     * Sets the value of the dashPhase property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setDashPhase(int value) {
        this.dashPhase = value;
    }

    public boolean isSetDashPhase() {
        return (this.dashPhase!= null);
    }

    public void unsetDashPhase() {
        this.dashPhase = null;
    }

    /**
     * Gets the value of the effectStyle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEffectStyle() {
        if (effectStyle == null) {
            return "";
        } else {
            return effectStyle;
        }
    }

    /**
     * Sets the value of the effectStyle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEffectStyle(String value) {
        this.effectStyle = value;
    }

    public boolean isSetEffectStyle() {
        return (this.effectStyle!= null);
    }

    /**
     * Gets the value of the effectIntensity property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getEffectIntensity() {
        if (effectIntensity == null) {
            return  0.0F;
        } else {
            return effectIntensity;
        }
    }

    /**
     * Sets the value of the effectIntensity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setEffectIntensity(float value) {
        this.effectIntensity = value;
    }

    public boolean isSetEffectIntensity() {
        return (this.effectIntensity!= null);
    }

    public void unsetEffectIntensity() {
        this.effectIntensity = null;
    }

    /**
     * Gets the value of the interiorColor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInteriorColor() {
        if (interiorColor == null) {
            return "#4800FF";
        } else {
            return interiorColor;
        }
    }

    /**
     * Sets the value of the interiorColor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInteriorColor(String value) {
        this.interiorColor = value;
    }

    public boolean isSetInteriorColor() {
        return (this.interiorColor!= null);
    }

}
