
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for BoxSelectionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="BoxSelectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="mediaBox"/>
 *     <enumeration value="cropBox"/>
 *     <enumeration value="bleedBox"/>
 *     <enumeration value="trimBox"/>
 *     <enumeration value="artBox"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BoxSelectionType")
@XmlEnum
public enum BoxSelectionType {

    @XmlEnumValue("mediaBox")
    MEDIA_BOX("mediaBox"),
    @XmlEnumValue("cropBox")
    CROP_BOX("cropBox"),
    @XmlEnumValue("bleedBox")
    BLEED_BOX("bleedBox"),
    @XmlEnumValue("trimBox")
    TRIM_BOX("trimBox"),
    @XmlEnumValue("artBox")
    ART_BOX("artBox");
    private final String value;

    BoxSelectionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static BoxSelectionType fromValue(String v) {
        for (BoxSelectionType c: BoxSelectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
