
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for DocMdpType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="DocMdpType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="noChangesAllowed"/>
 *     <enumeration value="formFillingSignatures"/>
 *     <enumeration value="formFillingSignaturesAnnotations"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DocMdpType")
@XmlEnum
public enum DocMdpType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("noChangesAllowed")
    NO_CHANGES_ALLOWED("noChangesAllowed"),
    @XmlEnumValue("formFillingSignatures")
    FORM_FILLING_SIGNATURES("formFillingSignatures"),
    @XmlEnumValue("formFillingSignaturesAnnotations")
    FORM_FILLING_SIGNATURES_ANNOTATIONS("formFillingSignaturesAnnotations");
    private final String value;

    DocMdpType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static DocMdpType fromValue(String v) {
        for (DocMdpType c: DocMdpType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
