
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PageLayoutType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PageLayoutType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="singlePage"/>
 *     <enumeration value="oneColumn"/>
 *     <enumeration value="twoColumnLeft"/>
 *     <enumeration value="twoColumnRight"/>
 *     <enumeration value="twoPageLeft"/>
 *     <enumeration value="twoPageRight"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageLayoutType")
@XmlEnum
public enum PageLayoutType {

    @XmlEnumValue("singlePage")
    SINGLE_PAGE("singlePage"),
    @XmlEnumValue("oneColumn")
    ONE_COLUMN("oneColumn"),
    @XmlEnumValue("twoColumnLeft")
    TWO_COLUMN_LEFT("twoColumnLeft"),
    @XmlEnumValue("twoColumnRight")
    TWO_COLUMN_RIGHT("twoColumnRight"),
    @XmlEnumValue("twoPageLeft")
    TWO_PAGE_LEFT("twoPageLeft"),
    @XmlEnumValue("twoPageRight")
    TWO_PAGE_RIGHT("twoPageRight");
    private final String value;

    PageLayoutType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PageLayoutType fromValue(String v) {
        for (PageLayoutType c: PageLayoutType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
