
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PrintScaleType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PrintScaleType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="readerDefault"/>
 *     <enumeration value="noPrintScaling"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PrintScaleType")
@XmlEnum
public enum PrintScaleType {

    @XmlEnumValue("readerDefault")
    READER_DEFAULT("readerDefault"),
    @XmlEnumValue("noPrintScaling")
    NO_PRINT_SCALING("noPrintScaling");
    private final String value;

    PrintScaleType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PrintScaleType fromValue(String v) {
        for (PrintScaleType c: PrintScaleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
