
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TransitionStyleType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="TransitionStyleType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="blinds"/>
 *     <enumeration value="box"/>
 *     <enumeration value="cover"/>
 *     <enumeration value="dissolve"/>
 *     <enumeration value="fade"/>
 *     <enumeration value="fly"/>
 *     <enumeration value="glitter"/>
 *     <enumeration value="push"/>
 *     <enumeration value="split"/>
 *     <enumeration value="uncover"/>
 *     <enumeration value="wipe"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TransitionStyleType")
@XmlEnum
public enum TransitionStyleType {

    @XmlEnumValue("blinds")
    BLINDS("blinds"),
    @XmlEnumValue("box")
    BOX("box"),
    @XmlEnumValue("cover")
    COVER("cover"),
    @XmlEnumValue("dissolve")
    DISSOLVE("dissolve"),
    @XmlEnumValue("fade")
    FADE("fade"),
    @XmlEnumValue("fly")
    FLY("fly"),
    @XmlEnumValue("glitter")
    GLITTER("glitter"),
    @XmlEnumValue("push")
    PUSH("push"),
    @XmlEnumValue("split")
    SPLIT("split"),
    @XmlEnumValue("uncover")
    UNCOVER("uncover"),
    @XmlEnumValue("wipe")
    WIPE("wipe"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    TransitionStyleType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TransitionStyleType fromValue(String v) {
        for (TransitionStyleType c: TransitionStyleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
