
package net.webpdf.wsclient.schema.extraction.text;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for LinkContentType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="LinkContentType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="action"/>
 *     <enumeration value="text"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "LinkContentType")
@XmlEnum
public enum LinkContentType {

    @XmlEnumValue("action")
    ACTION("action"),
    @XmlEnumValue("text")
    TEXT("text");
    private final String value;

    LinkContentType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static LinkContentType fromValue(String v) {
        for (LinkContentType c: LinkContentType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
