
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p105796_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p913707_="https://jakarta.ee/xml/ns/jaxb" xmlns:p931759_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation operation can be used to remove, edit or add markup annotations of/to a document.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for AnnotationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="AnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="add" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="text" type="{http://schema.webpdf.de/1.0/operation}TextAnnotationType"/>
 *                   <element name="markup" type="{http://schema.webpdf.de/1.0/operation}MarkupAnnotationType"/>
 *                   <element name="redact" type="{http://schema.webpdf.de/1.0/operation}RedactAnnotationType"/>
 *                   <element name="freetext" type="{http://schema.webpdf.de/1.0/operation}FreeTextAnnotationType"/>
 *                   <element name="rubberstamp" type="{http://schema.webpdf.de/1.0/operation}RubberStampAnnotationType"/>
 *                   <element name="circle" type="{http://schema.webpdf.de/1.0/operation}CircleAnnotationType"/>
 *                   <element name="square" type="{http://schema.webpdf.de/1.0/operation}SquareAnnotationType"/>
 *                   <element name="line" type="{http://schema.webpdf.de/1.0/operation}LineAnnotationType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="remove" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <all>
 *                   <element name="selection">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice maxOccurs="unbounded" minOccurs="0">
 *                             <element name="select" type="{http://schema.webpdf.de/1.0/operation}SelectionAnnotationType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </all>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="edit" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <all>
 *                   <element name="selection">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice maxOccurs="unbounded" minOccurs="0">
 *                             <element name="select" type="{http://schema.webpdf.de/1.0/operation}SelectionAnnotationType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="text" type="{http://schema.webpdf.de/1.0/operation}TextAnnotationType" minOccurs="0"/>
 *                   <element name="markup" type="{http://schema.webpdf.de/1.0/operation}MarkupAnnotationType" minOccurs="0"/>
 *                   <element name="redact" type="{http://schema.webpdf.de/1.0/operation}RedactAnnotationType" minOccurs="0"/>
 *                   <element name="freetext" type="{http://schema.webpdf.de/1.0/operation}FreeTextAnnotationType" minOccurs="0"/>
 *                   <element name="rubberstamp" type="{http://schema.webpdf.de/1.0/operation}RubberStampAnnotationType" minOccurs="0"/>
 *                   <element name="circle" type="{http://schema.webpdf.de/1.0/operation}CircleAnnotationType" minOccurs="0"/>
 *                   <element name="square" type="{http://schema.webpdf.de/1.0/operation}SquareAnnotationType" minOccurs="0"/>
 *                   <element name="line" type="{http://schema.webpdf.de/1.0/operation}LineAnnotationType" minOccurs="0"/>
 *                 </all>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="clear" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="flatten" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="comment" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice minOccurs="0">
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice maxOccurs="unbounded">
 *                             <element name="replyTo" type="{http://schema.webpdf.de/1.0/operation}ReplyToAnnotationType"/>
 *                             <element name="changeAnnotationState" type="{http://schema.webpdf.de/1.0/operation}ReplyStateAnnotationType"/>
 *                             <element name="markAnnotation" type="{http://schema.webpdf.de/1.0/operation}MarkedStateAnnotationType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="edit">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice maxOccurs="unbounded">
 *                             <element name="replyTo" type="{http://schema.webpdf.de/1.0/operation}ReplyToAnnotationEditType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AnnotationType", propOrder = {
    "add",
    "remove",
    "edit",
    "clear",
    "comment"
})
public class AnnotationType
    extends BaseToolboxType
{

    protected AnnotationType.Add add;
    protected AnnotationType.Remove remove;
    protected AnnotationType.Edit edit;
    protected AnnotationType.Clear clear;
    protected AnnotationType.Comment comment;

    /**
     * Gets the value of the add property.
     * 
     * @return
     *     possible object is
     *     {@link AnnotationType.Add }
     *     
     */
    public AnnotationType.Add getAdd() {
        return add;
    }

    /**
     * Sets the value of the add property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnnotationType.Add }
     *     
     */
    public void setAdd(AnnotationType.Add value) {
        this.add = value;
    }

    public boolean isSetAdd() {
        return (this.add!= null);
    }

    /**
     * Gets the value of the remove property.
     * 
     * @return
     *     possible object is
     *     {@link AnnotationType.Remove }
     *     
     */
    public AnnotationType.Remove getRemove() {
        return remove;
    }

    /**
     * Sets the value of the remove property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnnotationType.Remove }
     *     
     */
    public void setRemove(AnnotationType.Remove value) {
        this.remove = value;
    }

    public boolean isSetRemove() {
        return (this.remove!= null);
    }

    /**
     * Gets the value of the edit property.
     * 
     * @return
     *     possible object is
     *     {@link AnnotationType.Edit }
     *     
     */
    public AnnotationType.Edit getEdit() {
        return edit;
    }

    /**
     * Sets the value of the edit property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnnotationType.Edit }
     *     
     */
    public void setEdit(AnnotationType.Edit value) {
        this.edit = value;
    }

    public boolean isSetEdit() {
        return (this.edit!= null);
    }

    /**
     * Gets the value of the clear property.
     * 
     * @return
     *     possible object is
     *     {@link AnnotationType.Clear }
     *     
     */
    public AnnotationType.Clear getClear() {
        return clear;
    }

    /**
     * Sets the value of the clear property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnnotationType.Clear }
     *     
     */
    public void setClear(AnnotationType.Clear value) {
        this.clear = value;
    }

    public boolean isSetClear() {
        return (this.clear!= null);
    }

    /**
     * Gets the value of the comment property.
     * 
     * @return
     *     possible object is
     *     {@link AnnotationType.Comment }
     *     
     */
    public AnnotationType.Comment getComment() {
        return comment;
    }

    /**
     * Sets the value of the comment property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnnotationType.Comment }
     *     
     */
    public void setComment(AnnotationType.Comment value) {
        this.comment = value;
    }

    public boolean isSetComment() {
        return (this.comment!= null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="text" type="{http://schema.webpdf.de/1.0/operation}TextAnnotationType"/>
     *         <element name="markup" type="{http://schema.webpdf.de/1.0/operation}MarkupAnnotationType"/>
     *         <element name="redact" type="{http://schema.webpdf.de/1.0/operation}RedactAnnotationType"/>
     *         <element name="freetext" type="{http://schema.webpdf.de/1.0/operation}FreeTextAnnotationType"/>
     *         <element name="rubberstamp" type="{http://schema.webpdf.de/1.0/operation}RubberStampAnnotationType"/>
     *         <element name="circle" type="{http://schema.webpdf.de/1.0/operation}CircleAnnotationType"/>
     *         <element name="square" type="{http://schema.webpdf.de/1.0/operation}SquareAnnotationType"/>
     *         <element name="line" type="{http://schema.webpdf.de/1.0/operation}LineAnnotationType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "text",
        "markup",
        "redact",
        "freetext",
        "rubberstamp",
        "circle",
        "square",
        "line"
    })
    public static class Add {

        protected List<TextAnnotationType> text;
        protected List<MarkupAnnotationType> markup;
        protected List<RedactAnnotationType> redact;
        protected List<FreeTextAnnotationType> freetext;
        protected List<RubberStampAnnotationType> rubberstamp;
        protected List<CircleAnnotationType> circle;
        protected List<SquareAnnotationType> square;
        protected List<LineAnnotationType> line;

        /**
         * Gets the value of the text property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the text property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getText().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link TextAnnotationType }
         * 
         * 
         * @return
         *     The value of the text property.
         */
        public List<TextAnnotationType> getText() {
            if (text == null) {
                text = new ArrayList<>();
            }
            return this.text;
        }

        /**
         * Gets the value of the markup property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the markup property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getMarkup().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link MarkupAnnotationType }
         * 
         * 
         * @return
         *     The value of the markup property.
         */
        public List<MarkupAnnotationType> getMarkup() {
            if (markup == null) {
                markup = new ArrayList<>();
            }
            return this.markup;
        }

        /**
         * Gets the value of the redact property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the redact property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getRedact().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link RedactAnnotationType }
         * 
         * 
         * @return
         *     The value of the redact property.
         */
        public List<RedactAnnotationType> getRedact() {
            if (redact == null) {
                redact = new ArrayList<>();
            }
            return this.redact;
        }

        /**
         * Gets the value of the freetext property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the freetext property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getFreetext().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link FreeTextAnnotationType }
         * 
         * 
         * @return
         *     The value of the freetext property.
         */
        public List<FreeTextAnnotationType> getFreetext() {
            if (freetext == null) {
                freetext = new ArrayList<>();
            }
            return this.freetext;
        }

        /**
         * Gets the value of the rubberstamp property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the rubberstamp property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getRubberstamp().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link RubberStampAnnotationType }
         * 
         * 
         * @return
         *     The value of the rubberstamp property.
         */
        public List<RubberStampAnnotationType> getRubberstamp() {
            if (rubberstamp == null) {
                rubberstamp = new ArrayList<>();
            }
            return this.rubberstamp;
        }

        /**
         * Gets the value of the circle property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the circle property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getCircle().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link CircleAnnotationType }
         * 
         * 
         * @return
         *     The value of the circle property.
         */
        public List<CircleAnnotationType> getCircle() {
            if (circle == null) {
                circle = new ArrayList<>();
            }
            return this.circle;
        }

        /**
         * Gets the value of the square property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the square property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getSquare().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SquareAnnotationType }
         * 
         * 
         * @return
         *     The value of the square property.
         */
        public List<SquareAnnotationType> getSquare() {
            if (square == null) {
                square = new ArrayList<>();
            }
            return this.square;
        }

        /**
         * Gets the value of the line property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the line property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getLine().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link LineAnnotationType }
         * 
         * 
         * @return
         *     The value of the line property.
         */
        public List<LineAnnotationType> getLine() {
            if (line == null) {
                line = new ArrayList<>();
            }
            return this.line;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="flatten" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Clear {

        @XmlAttribute(name = "pages")
        protected String pages;
        @XmlAttribute(name = "flatten")
        protected Boolean flatten;

        /**
         * Gets the value of the pages property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPages() {
            if (pages == null) {
                return "";
            } else {
                return pages;
            }
        }

        /**
         * Sets the value of the pages property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setPages(String value) {
            this.pages = value;
        }

        public boolean isSetPages() {
            return (this.pages!= null);
        }

        /**
         * Gets the value of the flatten property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isFlatten() {
            if (flatten == null) {
                return false;
            } else {
                return flatten;
            }
        }

        /**
         * Sets the value of the flatten property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setFlatten(boolean value) {
            this.flatten = value;
        }

        public boolean isSetFlatten() {
            return (this.flatten!= null);
        }

        public void unsetFlatten() {
            this.flatten = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice minOccurs="0">
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice maxOccurs="unbounded">
     *                   <element name="replyTo" type="{http://schema.webpdf.de/1.0/operation}ReplyToAnnotationType"/>
     *                   <element name="changeAnnotationState" type="{http://schema.webpdf.de/1.0/operation}ReplyStateAnnotationType"/>
     *                   <element name="markAnnotation" type="{http://schema.webpdf.de/1.0/operation}MarkedStateAnnotationType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="edit">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice maxOccurs="unbounded">
     *                   <element name="replyTo" type="{http://schema.webpdf.de/1.0/operation}ReplyToAnnotationEditType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "edit"
    })
    public static class Comment {

        protected AnnotationType.Comment.Add add;
        protected AnnotationType.Comment.Edit edit;

        /**
         * Gets the value of the add property.
         * 
         * @return
         *     possible object is
         *     {@link AnnotationType.Comment.Add }
         *     
         */
        public AnnotationType.Comment.Add getAdd() {
            return add;
        }

        /**
         * Sets the value of the add property.
         * 
         * @param value
         *     allowed object is
         *     {@link AnnotationType.Comment.Add }
         *     
         */
        public void setAdd(AnnotationType.Comment.Add value) {
            this.add = value;
        }

        public boolean isSetAdd() {
            return (this.add!= null);
        }

        /**
         * Gets the value of the edit property.
         * 
         * @return
         *     possible object is
         *     {@link AnnotationType.Comment.Edit }
         *     
         */
        public AnnotationType.Comment.Edit getEdit() {
            return edit;
        }

        /**
         * Sets the value of the edit property.
         * 
         * @param value
         *     allowed object is
         *     {@link AnnotationType.Comment.Edit }
         *     
         */
        public void setEdit(AnnotationType.Comment.Edit value) {
            this.edit = value;
        }

        public boolean isSetEdit() {
            return (this.edit!= null);
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice maxOccurs="unbounded">
         *         <element name="replyTo" type="{http://schema.webpdf.de/1.0/operation}ReplyToAnnotationType"/>
         *         <element name="changeAnnotationState" type="{http://schema.webpdf.de/1.0/operation}ReplyStateAnnotationType"/>
         *         <element name="markAnnotation" type="{http://schema.webpdf.de/1.0/operation}MarkedStateAnnotationType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "replyTo",
            "changeAnnotationState",
            "markAnnotation"
        })
        public static class Add {

            protected List<ReplyToAnnotationType> replyTo;
            protected List<ReplyStateAnnotationType> changeAnnotationState;
            protected List<MarkedStateAnnotationType> markAnnotation;

            /**
             * Gets the value of the replyTo property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the Jakarta XML Binding object.
             * This is why there is not a {@code set} method for the replyTo property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getReplyTo().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link ReplyToAnnotationType }
             * 
             * 
             * @return
             *     The value of the replyTo property.
             */
            public List<ReplyToAnnotationType> getReplyTo() {
                if (replyTo == null) {
                    replyTo = new ArrayList<>();
                }
                return this.replyTo;
            }

            /**
             * Gets the value of the changeAnnotationState property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the Jakarta XML Binding object.
             * This is why there is not a {@code set} method for the changeAnnotationState property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getChangeAnnotationState().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link ReplyStateAnnotationType }
             * 
             * 
             * @return
             *     The value of the changeAnnotationState property.
             */
            public List<ReplyStateAnnotationType> getChangeAnnotationState() {
                if (changeAnnotationState == null) {
                    changeAnnotationState = new ArrayList<>();
                }
                return this.changeAnnotationState;
            }

            /**
             * Gets the value of the markAnnotation property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the Jakarta XML Binding object.
             * This is why there is not a {@code set} method for the markAnnotation property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getMarkAnnotation().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link MarkedStateAnnotationType }
             * 
             * 
             * @return
             *     The value of the markAnnotation property.
             */
            public List<MarkedStateAnnotationType> getMarkAnnotation() {
                if (markAnnotation == null) {
                    markAnnotation = new ArrayList<>();
                }
                return this.markAnnotation;
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice maxOccurs="unbounded">
         *         <element name="replyTo" type="{http://schema.webpdf.de/1.0/operation}ReplyToAnnotationEditType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "replyTo"
        })
        public static class Edit {

            protected List<ReplyToAnnotationEditType> replyTo;

            /**
             * Gets the value of the replyTo property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the Jakarta XML Binding object.
             * This is why there is not a {@code set} method for the replyTo property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getReplyTo().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link ReplyToAnnotationEditType }
             * 
             * 
             * @return
             *     The value of the replyTo property.
             */
            public List<ReplyToAnnotationEditType> getReplyTo() {
                if (replyTo == null) {
                    replyTo = new ArrayList<>();
                }
                return this.replyTo;
            }

            public boolean isSetReplyTo() {
                return ((this.replyTo!= null)&&(!this.replyTo.isEmpty()));
            }

            public void unsetReplyTo() {
                this.replyTo = null;
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <all>
     *         <element name="selection">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice maxOccurs="unbounded" minOccurs="0">
     *                   <element name="select" type="{http://schema.webpdf.de/1.0/operation}SelectionAnnotationType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="text" type="{http://schema.webpdf.de/1.0/operation}TextAnnotationType" minOccurs="0"/>
     *         <element name="markup" type="{http://schema.webpdf.de/1.0/operation}MarkupAnnotationType" minOccurs="0"/>
     *         <element name="redact" type="{http://schema.webpdf.de/1.0/operation}RedactAnnotationType" minOccurs="0"/>
     *         <element name="freetext" type="{http://schema.webpdf.de/1.0/operation}FreeTextAnnotationType" minOccurs="0"/>
     *         <element name="rubberstamp" type="{http://schema.webpdf.de/1.0/operation}RubberStampAnnotationType" minOccurs="0"/>
     *         <element name="circle" type="{http://schema.webpdf.de/1.0/operation}CircleAnnotationType" minOccurs="0"/>
     *         <element name="square" type="{http://schema.webpdf.de/1.0/operation}SquareAnnotationType" minOccurs="0"/>
     *         <element name="line" type="{http://schema.webpdf.de/1.0/operation}LineAnnotationType" minOccurs="0"/>
     *       </all>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {

    })
    public static class Edit {

        @XmlElement(required = true)
        protected AnnotationType.Edit.Selection selection;
        protected TextAnnotationType text;
        protected MarkupAnnotationType markup;
        protected RedactAnnotationType redact;
        protected FreeTextAnnotationType freetext;
        protected RubberStampAnnotationType rubberstamp;
        protected CircleAnnotationType circle;
        protected SquareAnnotationType square;
        protected LineAnnotationType line;

        /**
         * Gets the value of the selection property.
         * 
         * @return
         *     possible object is
         *     {@link AnnotationType.Edit.Selection }
         *     
         */
        public AnnotationType.Edit.Selection getSelection() {
            return selection;
        }

        /**
         * Sets the value of the selection property.
         * 
         * @param value
         *     allowed object is
         *     {@link AnnotationType.Edit.Selection }
         *     
         */
        public void setSelection(AnnotationType.Edit.Selection value) {
            this.selection = value;
        }

        public boolean isSetSelection() {
            return (this.selection!= null);
        }

        /**
         * Gets the value of the text property.
         * 
         * @return
         *     possible object is
         *     {@link TextAnnotationType }
         *     
         */
        public TextAnnotationType getText() {
            return text;
        }

        /**
         * Sets the value of the text property.
         * 
         * @param value
         *     allowed object is
         *     {@link TextAnnotationType }
         *     
         */
        public void setText(TextAnnotationType value) {
            this.text = value;
        }

        public boolean isSetText() {
            return (this.text!= null);
        }

        /**
         * Gets the value of the markup property.
         * 
         * @return
         *     possible object is
         *     {@link MarkupAnnotationType }
         *     
         */
        public MarkupAnnotationType getMarkup() {
            return markup;
        }

        /**
         * Sets the value of the markup property.
         * 
         * @param value
         *     allowed object is
         *     {@link MarkupAnnotationType }
         *     
         */
        public void setMarkup(MarkupAnnotationType value) {
            this.markup = value;
        }

        public boolean isSetMarkup() {
            return (this.markup!= null);
        }

        /**
         * Gets the value of the redact property.
         * 
         * @return
         *     possible object is
         *     {@link RedactAnnotationType }
         *     
         */
        public RedactAnnotationType getRedact() {
            return redact;
        }

        /**
         * Sets the value of the redact property.
         * 
         * @param value
         *     allowed object is
         *     {@link RedactAnnotationType }
         *     
         */
        public void setRedact(RedactAnnotationType value) {
            this.redact = value;
        }

        public boolean isSetRedact() {
            return (this.redact!= null);
        }

        /**
         * Gets the value of the freetext property.
         * 
         * @return
         *     possible object is
         *     {@link FreeTextAnnotationType }
         *     
         */
        public FreeTextAnnotationType getFreetext() {
            return freetext;
        }

        /**
         * Sets the value of the freetext property.
         * 
         * @param value
         *     allowed object is
         *     {@link FreeTextAnnotationType }
         *     
         */
        public void setFreetext(FreeTextAnnotationType value) {
            this.freetext = value;
        }

        public boolean isSetFreetext() {
            return (this.freetext!= null);
        }

        /**
         * Gets the value of the rubberstamp property.
         * 
         * @return
         *     possible object is
         *     {@link RubberStampAnnotationType }
         *     
         */
        public RubberStampAnnotationType getRubberstamp() {
            return rubberstamp;
        }

        /**
         * Sets the value of the rubberstamp property.
         * 
         * @param value
         *     allowed object is
         *     {@link RubberStampAnnotationType }
         *     
         */
        public void setRubberstamp(RubberStampAnnotationType value) {
            this.rubberstamp = value;
        }

        public boolean isSetRubberstamp() {
            return (this.rubberstamp!= null);
        }

        /**
         * Gets the value of the circle property.
         * 
         * @return
         *     possible object is
         *     {@link CircleAnnotationType }
         *     
         */
        public CircleAnnotationType getCircle() {
            return circle;
        }

        /**
         * Sets the value of the circle property.
         * 
         * @param value
         *     allowed object is
         *     {@link CircleAnnotationType }
         *     
         */
        public void setCircle(CircleAnnotationType value) {
            this.circle = value;
        }

        public boolean isSetCircle() {
            return (this.circle!= null);
        }

        /**
         * Gets the value of the square property.
         * 
         * @return
         *     possible object is
         *     {@link SquareAnnotationType }
         *     
         */
        public SquareAnnotationType getSquare() {
            return square;
        }

        /**
         * Sets the value of the square property.
         * 
         * @param value
         *     allowed object is
         *     {@link SquareAnnotationType }
         *     
         */
        public void setSquare(SquareAnnotationType value) {
            this.square = value;
        }

        public boolean isSetSquare() {
            return (this.square!= null);
        }

        /**
         * Gets the value of the line property.
         * 
         * @return
         *     possible object is
         *     {@link LineAnnotationType }
         *     
         */
        public LineAnnotationType getLine() {
            return line;
        }

        /**
         * Sets the value of the line property.
         * 
         * @param value
         *     allowed object is
         *     {@link LineAnnotationType }
         *     
         */
        public void setLine(LineAnnotationType value) {
            this.line = value;
        }

        public boolean isSetLine() {
            return (this.line!= null);
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice maxOccurs="unbounded" minOccurs="0">
         *         <element name="select" type="{http://schema.webpdf.de/1.0/operation}SelectionAnnotationType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "select"
        })
        public static class Selection {

            protected List<SelectionAnnotationType> select;

            /**
             * Gets the value of the select property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the Jakarta XML Binding object.
             * This is why there is not a {@code set} method for the select property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getSelect().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link SelectionAnnotationType }
             * 
             * 
             * @return
             *     The value of the select property.
             */
            public List<SelectionAnnotationType> getSelect() {
                if (select == null) {
                    select = new ArrayList<>();
                }
                return this.select;
            }

            public boolean isSetSelect() {
                return ((this.select!= null)&&(!this.select.isEmpty()));
            }

            public void unsetSelect() {
                this.select = null;
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <all>
     *         <element name="selection">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice maxOccurs="unbounded" minOccurs="0">
     *                   <element name="select" type="{http://schema.webpdf.de/1.0/operation}SelectionAnnotationType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </all>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {

    })
    public static class Remove {

        @XmlElement(required = true)
        protected AnnotationType.Remove.Selection selection;

        /**
         * Gets the value of the selection property.
         * 
         * @return
         *     possible object is
         *     {@link AnnotationType.Remove.Selection }
         *     
         */
        public AnnotationType.Remove.Selection getSelection() {
            return selection;
        }

        /**
         * Sets the value of the selection property.
         * 
         * @param value
         *     allowed object is
         *     {@link AnnotationType.Remove.Selection }
         *     
         */
        public void setSelection(AnnotationType.Remove.Selection value) {
            this.selection = value;
        }

        public boolean isSetSelection() {
            return (this.selection!= null);
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice maxOccurs="unbounded" minOccurs="0">
         *         <element name="select" type="{http://schema.webpdf.de/1.0/operation}SelectionAnnotationType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "select"
        })
        public static class Selection {

            protected List<SelectionAnnotationType> select;

            /**
             * Gets the value of the select property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the Jakarta XML Binding object.
             * This is why there is not a {@code set} method for the select property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getSelect().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link SelectionAnnotationType }
             * 
             * 
             * @return
             *     The value of the select property.
             */
            public List<SelectionAnnotationType> getSelect() {
                if (select == null) {
                    select = new ArrayList<>();
                }
                return this.select;
            }

            public boolean isSetSelect() {
                return ((this.select!= null)&&(!this.select.isEmpty()));
            }

            public void unsetSelect() {
                this.select = null;
            }

        }

    }

}
