
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AppearanceGenerationType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="AppearanceGenerationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="Always"/>
 *     <enumeration value="Never"/>
 *     <enumeration value="nonStandard"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AppearanceGenerationType")
@XmlEnum
public enum AppearanceGenerationType {

    @XmlEnumValue("Always")
    ALWAYS("Always"),
    @XmlEnumValue("Never")
    NEVER("Never"),
    @XmlEnumValue("nonStandard")
    NON_STANDARD("nonStandard");
    private final String value;

    AppearanceGenerationType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AppearanceGenerationType fromValue(String v) {
        for (AppearanceGenerationType c: AppearanceGenerationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
