
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AudioEncodingType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="AudioEncodingType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="Raw"/>
 *     <enumeration value="Signed"/>
 *     <enumeration value="muLaw"/>
 *     <enumeration value="ALaw"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AudioEncodingType")
@XmlEnum
public enum AudioEncodingType {

    @XmlEnumValue("Raw")
    RAW("Raw"),
    @XmlEnumValue("Signed")
    SIGNED("Signed"),
    @XmlEnumValue("muLaw")
    MU_LAW("muLaw"),
    @XmlEnumValue("ALaw")
    A_LAW("ALaw");
    private final String value;

    AudioEncodingType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AudioEncodingType fromValue(String v) {
        for (AudioEncodingType c: AudioEncodingType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
