
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AxisType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="AxisType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="x"/>
 *     <enumeration value="y"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AxisType")
@XmlEnum
public enum AxisType {

    @XmlEnumValue("x")
    X("x"),
    @XmlEnumValue("y")
    Y("y");
    private final String value;

    AxisType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AxisType fromValue(String v) {
        for (AxisType c: AxisType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
