
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for BarcodeCreateOutputFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="BarcodeCreateOutputFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pdf"/>
 *     <enumeration value="bmp"/>
 *     <enumeration value="jpg"/>
 *     <enumeration value="png"/>
 *     <enumeration value="tif"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BarcodeCreateOutputFormatType")
@XmlEnum
public enum BarcodeCreateOutputFormatType {

    @XmlEnumValue("pdf")
    PDF("pdf"),
    @XmlEnumValue("bmp")
    BMP("bmp"),
    @XmlEnumValue("jpg")
    JPG("jpg"),
    @XmlEnumValue("png")
    PNG("png"),
    @XmlEnumValue("tif")
    TIF("tif");
    private final String value;

    BarcodeCreateOutputFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static BarcodeCreateOutputFormatType fromValue(String v) {
        for (BarcodeCreateOutputFormatType c: BarcodeCreateOutputFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
