
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for BorderStyleType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="BorderStyleType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="solid"/>
 *     <enumeration value="dashed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BorderStyleType")
@XmlEnum
public enum BorderStyleType {

    @XmlEnumValue("solid")
    SOLID("solid"),
    @XmlEnumValue("dashed")
    DASHED("dashed");
    private final String value;

    BorderStyleType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static BorderStyleType fromValue(String v) {
        for (BorderStyleType c: BorderStyleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
