
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CertificationLevelType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="CertificationLevelType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="noChanges"/>
 *     <enumeration value="formFillingAndSignatures"/>
 *     <enumeration value="formFillingAndSignaturesAndAnnotations"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "CertificationLevelType")
@XmlEnum
public enum CertificationLevelType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("noChanges")
    NO_CHANGES("noChanges"),
    @XmlEnumValue("formFillingAndSignatures")
    FORM_FILLING_AND_SIGNATURES("formFillingAndSignatures"),
    @XmlEnumValue("formFillingAndSignaturesAndAnnotations")
    FORM_FILLING_AND_SIGNATURES_AND_ANNOTATIONS("formFillingAndSignaturesAndAnnotations");
    private final String value;

    CertificationLevelType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static CertificationLevelType fromValue(String v) {
        for (CertificationLevelType c: CertificationLevelType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
