
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CompressProfileType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="CompressProfileType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="always"/>
 *     <enumeration value="never"/>
 *     <enumeration value="recompress"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "CompressProfileType")
@XmlEnum
public enum CompressProfileType {

    @XmlEnumValue("always")
    ALWAYS("always"),
    @XmlEnumValue("never")
    NEVER("never"),
    @XmlEnumValue("recompress")
    RECOMPRESS("recompress");
    private final String value;

    CompressProfileType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static CompressProfileType fromValue(String v) {
        for (CompressProfileType c: CompressProfileType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
