
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p383362_="https://jakarta.ee/xml/ns/jaxb" xmlns:p837822_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Performs the conversion of a document.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ConverterType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ConverterType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="page" type="{http://schema.webpdf.de/1.0/operation}ConverterPageType" minOccurs="0"/>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaType" minOccurs="0"/>
 *         <element name="signature" type="{http://schema.webpdf.de/1.0/operation}SignatureType" minOccurs="0"/>
 *         <element name="html" type="{http://schema.webpdf.de/1.0/operation}ConverterHtmlType" minOccurs="0"/>
 *         <element name="mail" type="{http://schema.webpdf.de/1.0/operation}ConverterMailType" minOccurs="0"/>
 *         <element name="officeBridge" type="{http://schema.webpdf.de/1.0/operation}OfficeBridgeType" minOccurs="0"/>
 *         <element name="sharePointBridge" type="{http://schema.webpdf.de/1.0/operation}SharePointBridgeType" minOccurs="0"/>
 *         <element name="report" type="{http://schema.webpdf.de/1.0/operation}ConverterReportType" minOccurs="0"/>
 *         <element name="template" type="{http://schema.webpdf.de/1.0/operation}ConverterTemplateType" minOccurs="0"/>
 *         <element name="text" type="{http://schema.webpdf.de/1.0/operation}ConverterTextType" minOccurs="0"/>
 *         <element name="transform" type="{http://schema.webpdf.de/1.0/operation}ConverterTransformType" minOccurs="0"/>
 *         <element name="image" type="{http://schema.webpdf.de/1.0/operation}ConverterImageType" minOccurs="0"/>
 *       </all>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="compression" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="jpegQuality" default="90">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="reduceResolution" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="dpi" default="300">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}DpiType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="embedFonts" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="accessPassword" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="fileExtension" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="maxRecursion" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConverterType", propOrder = {

})
public class ConverterType
    implements ParameterInterface
{

    protected ConverterPageType page;
    protected PdfaType pdfa;
    protected SignatureType signature;
    protected ConverterHtmlType html;
    protected ConverterMailType mail;
    protected OfficeBridgeType officeBridge;
    protected SharePointBridgeType sharePointBridge;
    protected ConverterReportType report;
    protected ConverterTemplateType template;
    protected ConverterTextType text;
    protected ConverterTransformType transform;
    protected ConverterImageType image;
    @XmlAttribute(name = "pages")
    protected String pages;
    @XmlAttribute(name = "compression")
    protected Boolean compression;
    @XmlAttribute(name = "jpegQuality")
    protected Integer jpegQuality;
    @XmlAttribute(name = "reduceResolution")
    protected Boolean reduceResolution;
    @XmlAttribute(name = "dpi")
    protected Integer dpi;
    @XmlAttribute(name = "embedFonts")
    protected Boolean embedFonts;
    @XmlAttribute(name = "accessPassword")
    protected String accessPassword;
    @XmlAttribute(name = "fileExtension")
    protected String fileExtension;
    @XmlAttribute(name = "maxRecursion")
    protected Integer maxRecursion;

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterPageType }
     *     
     */
    public ConverterPageType getPage() {
        return page;
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterPageType }
     *     
     */
    public void setPage(ConverterPageType value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaType }
     *     
     */
    public PdfaType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType }
     *     
     */
    public void setPdfa(PdfaType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    public boolean isSetSignature() {
        return (this.signature!= null);
    }

    /**
     * Gets the value of the html property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterHtmlType }
     *     
     */
    public ConverterHtmlType getHtml() {
        return html;
    }

    /**
     * Sets the value of the html property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterHtmlType }
     *     
     */
    public void setHtml(ConverterHtmlType value) {
        this.html = value;
    }

    public boolean isSetHtml() {
        return (this.html!= null);
    }

    /**
     * Gets the value of the mail property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterMailType }
     *     
     */
    public ConverterMailType getMail() {
        return mail;
    }

    /**
     * Sets the value of the mail property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterMailType }
     *     
     */
    public void setMail(ConverterMailType value) {
        this.mail = value;
    }

    public boolean isSetMail() {
        return (this.mail!= null);
    }

    /**
     * Gets the value of the officeBridge property.
     * 
     * @return
     *     possible object is
     *     {@link OfficeBridgeType }
     *     
     */
    public OfficeBridgeType getOfficeBridge() {
        return officeBridge;
    }

    /**
     * Sets the value of the officeBridge property.
     * 
     * @param value
     *     allowed object is
     *     {@link OfficeBridgeType }
     *     
     */
    public void setOfficeBridge(OfficeBridgeType value) {
        this.officeBridge = value;
    }

    public boolean isSetOfficeBridge() {
        return (this.officeBridge!= null);
    }

    /**
     * Gets the value of the sharePointBridge property.
     * 
     * @return
     *     possible object is
     *     {@link SharePointBridgeType }
     *     
     */
    public SharePointBridgeType getSharePointBridge() {
        return sharePointBridge;
    }

    /**
     * Sets the value of the sharePointBridge property.
     * 
     * @param value
     *     allowed object is
     *     {@link SharePointBridgeType }
     *     
     */
    public void setSharePointBridge(SharePointBridgeType value) {
        this.sharePointBridge = value;
    }

    public boolean isSetSharePointBridge() {
        return (this.sharePointBridge!= null);
    }

    /**
     * Gets the value of the report property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterReportType }
     *     
     */
    public ConverterReportType getReport() {
        return report;
    }

    /**
     * Sets the value of the report property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterReportType }
     *     
     */
    public void setReport(ConverterReportType value) {
        this.report = value;
    }

    public boolean isSetReport() {
        return (this.report!= null);
    }

    /**
     * Gets the value of the template property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterTemplateType }
     *     
     */
    public ConverterTemplateType getTemplate() {
        return template;
    }

    /**
     * Sets the value of the template property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterTemplateType }
     *     
     */
    public void setTemplate(ConverterTemplateType value) {
        this.template = value;
    }

    public boolean isSetTemplate() {
        return (this.template!= null);
    }

    /**
     * Gets the value of the text property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterTextType }
     *     
     */
    public ConverterTextType getText() {
        return text;
    }

    /**
     * Sets the value of the text property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterTextType }
     *     
     */
    public void setText(ConverterTextType value) {
        this.text = value;
    }

    public boolean isSetText() {
        return (this.text!= null);
    }

    /**
     * Gets the value of the transform property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterTransformType }
     *     
     */
    public ConverterTransformType getTransform() {
        return transform;
    }

    /**
     * Sets the value of the transform property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterTransformType }
     *     
     */
    public void setTransform(ConverterTransformType value) {
        this.transform = value;
    }

    public boolean isSetTransform() {
        return (this.transform!= null);
    }

    /**
     * Gets the value of the image property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterImageType }
     *     
     */
    public ConverterImageType getImage() {
        return image;
    }

    /**
     * Sets the value of the image property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterImageType }
     *     
     */
    public void setImage(ConverterImageType value) {
        this.image = value;
    }

    public boolean isSetImage() {
        return (this.image!= null);
    }

    /**
     * Gets the value of the pages property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * Gets the value of the compression property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCompression() {
        if (compression == null) {
            return true;
        } else {
            return compression;
        }
    }

    /**
     * Sets the value of the compression property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCompression(boolean value) {
        this.compression = value;
    }

    public boolean isSetCompression() {
        return (this.compression!= null);
    }

    public void unsetCompression() {
        this.compression = null;
    }

    /**
     * Gets the value of the jpegQuality property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getJpegQuality() {
        if (jpegQuality == null) {
            return  90;
        } else {
            return jpegQuality;
        }
    }

    /**
     * Sets the value of the jpegQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setJpegQuality(int value) {
        this.jpegQuality = value;
    }

    public boolean isSetJpegQuality() {
        return (this.jpegQuality!= null);
    }

    public void unsetJpegQuality() {
        this.jpegQuality = null;
    }

    /**
     * Gets the value of the reduceResolution property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isReduceResolution() {
        if (reduceResolution == null) {
            return false;
        } else {
            return reduceResolution;
        }
    }

    /**
     * Sets the value of the reduceResolution property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReduceResolution(boolean value) {
        this.reduceResolution = value;
    }

    public boolean isSetReduceResolution() {
        return (this.reduceResolution!= null);
    }

    public void unsetReduceResolution() {
        this.reduceResolution = null;
    }

    /**
     * Gets the value of the dpi property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  300;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

    /**
     * Gets the value of the embedFonts property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEmbedFonts() {
        if (embedFonts == null) {
            return false;
        } else {
            return embedFonts;
        }
    }

    /**
     * Sets the value of the embedFonts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setEmbedFonts(boolean value) {
        this.embedFonts = value;
    }

    public boolean isSetEmbedFonts() {
        return (this.embedFonts!= null);
    }

    public void unsetEmbedFonts() {
        this.embedFonts = null;
    }

    /**
     * Gets the value of the accessPassword property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccessPassword() {
        if (accessPassword == null) {
            return "";
        } else {
            return accessPassword;
        }
    }

    /**
     * Sets the value of the accessPassword property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccessPassword(String value) {
        this.accessPassword = value;
    }

    public boolean isSetAccessPassword() {
        return (this.accessPassword!= null);
    }

    /**
     * Gets the value of the fileExtension property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileExtension() {
        if (fileExtension == null) {
            return "";
        } else {
            return fileExtension;
        }
    }

    /**
     * Sets the value of the fileExtension property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFileExtension(String value) {
        this.fileExtension = value;
    }

    public boolean isSetFileExtension() {
        return (this.fileExtension!= null);
    }

    /**
     * Gets the value of the maxRecursion property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMaxRecursion() {
        if (maxRecursion == null) {
            return  1;
        } else {
            return maxRecursion;
        }
    }

    /**
     * Sets the value of the maxRecursion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setMaxRecursion(int value) {
        this.maxRecursion = value;
    }

    public boolean isSetMaxRecursion() {
        return (this.maxRecursion!= null);
    }

    public void unsetMaxRecursion() {
        this.maxRecursion = null;
    }

}
