
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p321944_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p909790_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;These parameters can be used to set the asymmetric encryption of a PDF document.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for EncryptCertificateType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="EncryptCertificateType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="recipient" type="{http://schema.webpdf.de/1.0/operation}RecipientType" maxOccurs="unbounded"/>
 *       </sequence>
 *       <attribute name="encryptionKey" type="{http://schema.webpdf.de/1.0/operation}PdfEncryptionKeyType" default="RC4_128" />
 *       <attribute name="contentEncryption" type="{http://schema.webpdf.de/1.0/operation}PdfContentEncryptionType" default="encryptEverything" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EncryptCertificateType", propOrder = {
    "recipient"
})
public class EncryptCertificateType {

    @XmlElement(required = true)
    protected List<RecipientType> recipient;
    @XmlAttribute(name = "encryptionKey")
    protected PdfEncryptionKeyType encryptionKey;
    @XmlAttribute(name = "contentEncryption")
    protected PdfContentEncryptionType contentEncryption;

    /**
     * Gets the value of the recipient property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the recipient property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRecipient().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecipientType }
     * 
     * 
     * @return
     *     The value of the recipient property.
     */
    public List<RecipientType> getRecipient() {
        if (recipient == null) {
            recipient = new ArrayList<>();
        }
        return this.recipient;
    }

    public boolean isSetRecipient() {
        return ((this.recipient!= null)&&(!this.recipient.isEmpty()));
    }

    public void unsetRecipient() {
        this.recipient = null;
    }

    /**
     * Gets the value of the encryptionKey property.
     * 
     * @return
     *     possible object is
     *     {@link PdfEncryptionKeyType }
     *     
     */
    public PdfEncryptionKeyType getEncryptionKey() {
        if (encryptionKey == null) {
            return PdfEncryptionKeyType.RC_4_128;
        } else {
            return encryptionKey;
        }
    }

    /**
     * Sets the value of the encryptionKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfEncryptionKeyType }
     *     
     */
    public void setEncryptionKey(PdfEncryptionKeyType value) {
        this.encryptionKey = value;
    }

    public boolean isSetEncryptionKey() {
        return (this.encryptionKey!= null);
    }

    /**
     * Gets the value of the contentEncryption property.
     * 
     * @return
     *     possible object is
     *     {@link PdfContentEncryptionType }
     *     
     */
    public PdfContentEncryptionType getContentEncryption() {
        if (contentEncryption == null) {
            return PdfContentEncryptionType.ENCRYPT_EVERYTHING;
        } else {
            return contentEncryption;
        }
    }

    /**
     * Sets the value of the contentEncryption property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfContentEncryptionType }
     *     
     */
    public void setContentEncryption(PdfContentEncryptionType value) {
        this.contentEncryption = value;
    }

    public boolean isSetContentEncryption() {
        return (this.contentEncryption!= null);
    }

}
