
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ExtractionImageFormat.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="ExtractionImageFormat">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="png"/>
 *     <enumeration value="jpeg"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ExtractionImageFormat")
@XmlEnum
public enum ExtractionImageFormat {

    @XmlEnumValue("png")
    PNG("png"),
    @XmlEnumValue("jpeg")
    JPEG("jpeg");
    private final String value;

    ExtractionImageFormat(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ExtractionImageFormat fromValue(String v) {
        for (ExtractionImageFormat c: ExtractionImageFormat.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
