
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FailureType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="FailureType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="warning"/>
 *     <enumeration value="missingContent"/>
 *     <enumeration value="error"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FailureType")
@XmlEnum
public enum FailureType {

    @XmlEnumValue("warning")
    WARNING("warning"),
    @XmlEnumValue("missingContent")
    MISSING_CONTENT("missingContent"),
    @XmlEnumValue("error")
    ERROR("error");
    private final String value;

    FailureType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FailureType fromValue(String v) {
        for (FailureType c: FailureType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
