
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FileDataSourceType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="FileDataSourceType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="value"/>
 *     <enumeration value="uri"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FileDataSourceType")
@XmlEnum
public enum FileDataSourceType {

    @XmlEnumValue("value")
    VALUE("value"),
    @XmlEnumValue("uri")
    URI("uri");
    private final String value;

    FileDataSourceType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FileDataSourceType fromValue(String v) {
        for (FileDataSourceType c: FileDataSourceType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
