
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FontOriginModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="FontOriginModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="system"/>
 *     <enumeration value="folder"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FontOriginModeType")
@XmlEnum
public enum FontOriginModeType {

    @XmlEnumValue("system")
    SYSTEM("system"),
    @XmlEnumValue("folder")
    FOLDER("folder");
    private final String value;

    FontOriginModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FontOriginModeType fromValue(String v) {
        for (FontOriginModeType c: FontOriginModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
