
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FormsFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="FormsFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="xml"/>
 *     <enumeration value="fdf"/>
 *     <enumeration value="xfdf"/>
 *     <enumeration value="xdp"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FormsFormatType")
@XmlEnum
public enum FormsFormatType {

    @XmlEnumValue("xml")
    XML("xml"),
    @XmlEnumValue("fdf")
    FDF("fdf"),
    @XmlEnumValue("xfdf")
    XFDF("xfdf"),
    @XmlEnumValue("xdp")
    XDP("xdp");
    private final String value;

    FormsFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FormsFormatType fromValue(String v) {
        for (FormsFormatType c: FormsFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
