
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for IconsType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="IconsType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="graph"/>
 *     <enumeration value="paperclip"/>
 *     <enumeration value="pushPin"/>
 *     <enumeration value="tag"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "IconsType")
@XmlEnum
public enum IconsType {

    @XmlEnumValue("graph")
    GRAPH("graph"),
    @XmlEnumValue("paperclip")
    PAPERCLIP("paperclip"),
    @XmlEnumValue("pushPin")
    PUSH_PIN("pushPin"),
    @XmlEnumValue("tag")
    TAG("tag"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    IconsType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static IconsType fromValue(String v) {
        for (IconsType c: IconsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
