
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p20622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p420076_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The optimization element allows to correct the images of the pages to optimize them for OCR. Except for the "deskew" parameter, none of the optimizations are actually visible in the generated documents. The other optimizations are only used to improve the text recognition.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ImageOptimizationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ImageOptimizationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="deskew" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="despeckle" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="reduceDithering" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="noiseReduction" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="noiseReductionValue" default="1.0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0.0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="gammaCorrection" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="off" />
 *       <attribute name="gammaCorrectionValue" default="0.0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0.0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="increaseContrast" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="off" />
 *       <attribute name="increaseContrastValue" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="-100"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="edgeAccentuation" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="edgeAccentuationValue" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="sharpen" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="sharpenValue" default="1.0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0.0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="medianFilter" type="{http://schema.webpdf.de/1.0/operation}OptimizationIntensityType" default="low" />
 *       <attribute name="medianFilterValue" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ImageOptimizationType")
public class ImageOptimizationType {

    @XmlAttribute(name = "deskew")
    protected Boolean deskew;
    @XmlAttribute(name = "despeckle")
    protected Boolean despeckle;
    @XmlAttribute(name = "reduceDithering")
    protected Boolean reduceDithering;
    @XmlAttribute(name = "noiseReduction")
    protected OptimizationIntensityType noiseReduction;
    @XmlAttribute(name = "noiseReductionValue")
    protected Float noiseReductionValue;
    @XmlAttribute(name = "gammaCorrection")
    protected OptimizationIntensityType gammaCorrection;
    @XmlAttribute(name = "gammaCorrectionValue")
    protected Float gammaCorrectionValue;
    @XmlAttribute(name = "increaseContrast")
    protected OptimizationIntensityType increaseContrast;
    @XmlAttribute(name = "increaseContrastValue")
    protected Integer increaseContrastValue;
    @XmlAttribute(name = "edgeAccentuation")
    protected OptimizationIntensityType edgeAccentuation;
    @XmlAttribute(name = "edgeAccentuationValue")
    protected Integer edgeAccentuationValue;
    @XmlAttribute(name = "sharpen")
    protected OptimizationIntensityType sharpen;
    @XmlAttribute(name = "sharpenValue")
    protected Float sharpenValue;
    @XmlAttribute(name = "medianFilter")
    protected OptimizationIntensityType medianFilter;
    @XmlAttribute(name = "medianFilterValue")
    protected Integer medianFilterValue;

    /**
     * Gets the value of the deskew property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDeskew() {
        if (deskew == null) {
            return true;
        } else {
            return deskew;
        }
    }

    /**
     * Sets the value of the deskew property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDeskew(boolean value) {
        this.deskew = value;
    }

    public boolean isSetDeskew() {
        return (this.deskew!= null);
    }

    public void unsetDeskew() {
        this.deskew = null;
    }

    /**
     * Gets the value of the despeckle property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDespeckle() {
        if (despeckle == null) {
            return true;
        } else {
            return despeckle;
        }
    }

    /**
     * Sets the value of the despeckle property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDespeckle(boolean value) {
        this.despeckle = value;
    }

    public boolean isSetDespeckle() {
        return (this.despeckle!= null);
    }

    public void unsetDespeckle() {
        this.despeckle = null;
    }

    /**
     * Gets the value of the reduceDithering property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isReduceDithering() {
        if (reduceDithering == null) {
            return false;
        } else {
            return reduceDithering;
        }
    }

    /**
     * Sets the value of the reduceDithering property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReduceDithering(boolean value) {
        this.reduceDithering = value;
    }

    public boolean isSetReduceDithering() {
        return (this.reduceDithering!= null);
    }

    public void unsetReduceDithering() {
        this.reduceDithering = null;
    }

    /**
     * Gets the value of the noiseReduction property.
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getNoiseReduction() {
        if (noiseReduction == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return noiseReduction;
        }
    }

    /**
     * Sets the value of the noiseReduction property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public void setNoiseReduction(OptimizationIntensityType value) {
        this.noiseReduction = value;
    }

    public boolean isSetNoiseReduction() {
        return (this.noiseReduction!= null);
    }

    /**
     * Gets the value of the noiseReductionValue property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getNoiseReductionValue() {
        if (noiseReductionValue == null) {
            return  1.0F;
        } else {
            return noiseReductionValue;
        }
    }

    /**
     * Sets the value of the noiseReductionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setNoiseReductionValue(float value) {
        this.noiseReductionValue = value;
    }

    public boolean isSetNoiseReductionValue() {
        return (this.noiseReductionValue!= null);
    }

    public void unsetNoiseReductionValue() {
        this.noiseReductionValue = null;
    }

    /**
     * Gets the value of the gammaCorrection property.
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getGammaCorrection() {
        if (gammaCorrection == null) {
            return OptimizationIntensityType.OFF;
        } else {
            return gammaCorrection;
        }
    }

    /**
     * Sets the value of the gammaCorrection property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public void setGammaCorrection(OptimizationIntensityType value) {
        this.gammaCorrection = value;
    }

    public boolean isSetGammaCorrection() {
        return (this.gammaCorrection!= null);
    }

    /**
     * Gets the value of the gammaCorrectionValue property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getGammaCorrectionValue() {
        if (gammaCorrectionValue == null) {
            return  0.0F;
        } else {
            return gammaCorrectionValue;
        }
    }

    /**
     * Sets the value of the gammaCorrectionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setGammaCorrectionValue(float value) {
        this.gammaCorrectionValue = value;
    }

    public boolean isSetGammaCorrectionValue() {
        return (this.gammaCorrectionValue!= null);
    }

    public void unsetGammaCorrectionValue() {
        this.gammaCorrectionValue = null;
    }

    /**
     * Gets the value of the increaseContrast property.
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getIncreaseContrast() {
        if (increaseContrast == null) {
            return OptimizationIntensityType.OFF;
        } else {
            return increaseContrast;
        }
    }

    /**
     * Sets the value of the increaseContrast property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public void setIncreaseContrast(OptimizationIntensityType value) {
        this.increaseContrast = value;
    }

    public boolean isSetIncreaseContrast() {
        return (this.increaseContrast!= null);
    }

    /**
     * Gets the value of the increaseContrastValue property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getIncreaseContrastValue() {
        if (increaseContrastValue == null) {
            return  0;
        } else {
            return increaseContrastValue;
        }
    }

    /**
     * Sets the value of the increaseContrastValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setIncreaseContrastValue(int value) {
        this.increaseContrastValue = value;
    }

    public boolean isSetIncreaseContrastValue() {
        return (this.increaseContrastValue!= null);
    }

    public void unsetIncreaseContrastValue() {
        this.increaseContrastValue = null;
    }

    /**
     * Gets the value of the edgeAccentuation property.
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getEdgeAccentuation() {
        if (edgeAccentuation == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return edgeAccentuation;
        }
    }

    /**
     * Sets the value of the edgeAccentuation property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public void setEdgeAccentuation(OptimizationIntensityType value) {
        this.edgeAccentuation = value;
    }

    public boolean isSetEdgeAccentuation() {
        return (this.edgeAccentuation!= null);
    }

    /**
     * Gets the value of the edgeAccentuationValue property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getEdgeAccentuationValue() {
        if (edgeAccentuationValue == null) {
            return  100;
        } else {
            return edgeAccentuationValue;
        }
    }

    /**
     * Sets the value of the edgeAccentuationValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setEdgeAccentuationValue(int value) {
        this.edgeAccentuationValue = value;
    }

    public boolean isSetEdgeAccentuationValue() {
        return (this.edgeAccentuationValue!= null);
    }

    public void unsetEdgeAccentuationValue() {
        this.edgeAccentuationValue = null;
    }

    /**
     * Gets the value of the sharpen property.
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getSharpen() {
        if (sharpen == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return sharpen;
        }
    }

    /**
     * Sets the value of the sharpen property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public void setSharpen(OptimizationIntensityType value) {
        this.sharpen = value;
    }

    public boolean isSetSharpen() {
        return (this.sharpen!= null);
    }

    /**
     * Gets the value of the sharpenValue property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getSharpenValue() {
        if (sharpenValue == null) {
            return  1.0F;
        } else {
            return sharpenValue;
        }
    }

    /**
     * Sets the value of the sharpenValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setSharpenValue(float value) {
        this.sharpenValue = value;
    }

    public boolean isSetSharpenValue() {
        return (this.sharpenValue!= null);
    }

    public void unsetSharpenValue() {
        this.sharpenValue = null;
    }

    /**
     * Gets the value of the medianFilter property.
     * 
     * @return
     *     possible object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public OptimizationIntensityType getMedianFilter() {
        if (medianFilter == null) {
            return OptimizationIntensityType.LOW;
        } else {
            return medianFilter;
        }
    }

    /**
     * Sets the value of the medianFilter property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimizationIntensityType }
     *     
     */
    public void setMedianFilter(OptimizationIntensityType value) {
        this.medianFilter = value;
    }

    public boolean isSetMedianFilter() {
        return (this.medianFilter!= null);
    }

    /**
     * Gets the value of the medianFilterValue property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMedianFilterValue() {
        if (medianFilterValue == null) {
            return  1;
        } else {
            return medianFilterValue;
        }
    }

    /**
     * Sets the value of the medianFilterValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setMedianFilterValue(int value) {
        this.medianFilterValue = value;
    }

    public boolean isSetMedianFilterValue() {
        return (this.medianFilterValue!= null);
    }

    public void unsetMedianFilterValue() {
        this.medianFilterValue = null;
    }

}
