
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for JustificationType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="JustificationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="leftJustified"/>
 *     <enumeration value="centered"/>
 *     <enumeration value="rightJustified"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "JustificationType")
@XmlEnum
public enum JustificationType {

    @XmlEnumValue("leftJustified")
    LEFT_JUSTIFIED("leftJustified"),
    @XmlEnumValue("centered")
    CENTERED("centered"),
    @XmlEnumValue("rightJustified")
    RIGHT_JUSTIFIED("rightJustified");
    private final String value;

    JustificationType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JustificationType fromValue(String v) {
        for (JustificationType c: JustificationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
