
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MergeModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="MergeModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="atTheEnd"/>
 *     <enumeration value="atTheBeginning"/>
 *     <enumeration value="afterPage"/>
 *     <enumeration value="beforePage"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MergeModeType")
@XmlEnum
public enum MergeModeType {

    @XmlEnumValue("atTheEnd")
    AT_THE_END("atTheEnd"),
    @XmlEnumValue("atTheBeginning")
    AT_THE_BEGINNING("atTheBeginning"),
    @XmlEnumValue("afterPage")
    AFTER_PAGE("afterPage"),
    @XmlEnumValue("beforePage")
    BEFORE_PAGE("beforePage");
    private final String value;

    MergeModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MergeModeType fromValue(String v) {
        for (MergeModeType c: MergeModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
