
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p69245_="https://jakarta.ee/xml/ns/jaxb" xmlns:p890116_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The merge operation element can be used to merge documents.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p69245_="https://jakarta.ee/xml/ns/jaxb" xmlns:p890116_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     When a "merge" operation is performed, the pages and structural information (such as outlines and tag) will be merged. This can result in name conflicts that can prevent a success. If you would rather like to ignore such conflicts use the matching "ignoreConflicts" parameter.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p69245_="https://jakarta.ee/xml/ns/jaxb" xmlns:p890116_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Merging documents could also fail because of signatures or a used PDF/A format. As&#13;
 *                     &lt;ul&gt;&lt;li&gt;by definition - altering PDF/A documents and signed documents would result in an invalidation of such documents/signatures.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for MergeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="MergeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <all>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}MergeFileDataType"/>
 *       </all>
 *       <attribute name="mode" type="{http://schema.webpdf.de/1.0/operation}MergeModeType" default="atTheEnd" />
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="sourceIsZip" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="outlineName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="resetMetadata" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="removeStaticXFA" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MergeType", propOrder = {
    "data"
})
public class MergeType
    extends BaseToolboxType
{

    @XmlElement(required = true)
    protected MergeFileDataType data;
    @XmlAttribute(name = "mode")
    protected MergeModeType mode;
    @XmlAttribute(name = "page")
    protected Integer page;
    @XmlAttribute(name = "sourceIsZip")
    protected Boolean sourceIsZip;
    @XmlAttribute(name = "outlineName")
    protected String outlineName;
    @XmlAttribute(name = "resetMetadata")
    protected Boolean resetMetadata;
    @XmlAttribute(name = "removeStaticXFA")
    protected Boolean removeStaticXFA;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link MergeFileDataType }
     *     
     */
    public MergeFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link MergeFileDataType }
     *     
     */
    public void setData(MergeFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * Gets the value of the mode property.
     * 
     * @return
     *     possible object is
     *     {@link MergeModeType }
     *     
     */
    public MergeModeType getMode() {
        if (mode == null) {
            return MergeModeType.AT_THE_END;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MergeModeType }
     *     
     */
    public void setMode(MergeModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * Gets the value of the sourceIsZip property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSourceIsZip() {
        if (sourceIsZip == null) {
            return false;
        } else {
            return sourceIsZip;
        }
    }

    /**
     * Sets the value of the sourceIsZip property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSourceIsZip(boolean value) {
        this.sourceIsZip = value;
    }

    public boolean isSetSourceIsZip() {
        return (this.sourceIsZip!= null);
    }

    public void unsetSourceIsZip() {
        this.sourceIsZip = null;
    }

    /**
     * Gets the value of the outlineName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOutlineName() {
        if (outlineName == null) {
            return "";
        } else {
            return outlineName;
        }
    }

    /**
     * Sets the value of the outlineName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOutlineName(String value) {
        this.outlineName = value;
    }

    public boolean isSetOutlineName() {
        return (this.outlineName!= null);
    }

    /**
     * Gets the value of the resetMetadata property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isResetMetadata() {
        if (resetMetadata == null) {
            return false;
        } else {
            return resetMetadata;
        }
    }

    /**
     * Sets the value of the resetMetadata property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setResetMetadata(boolean value) {
        this.resetMetadata = value;
    }

    public boolean isSetResetMetadata() {
        return (this.resetMetadata!= null);
    }

    public void unsetResetMetadata() {
        this.resetMetadata = null;
    }

    /**
     * Gets the value of the removeStaticXFA property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRemoveStaticXFA() {
        if (removeStaticXFA == null) {
            return false;
        } else {
            return removeStaticXFA;
        }
    }

    /**
     * Sets the value of the removeStaticXFA property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRemoveStaticXFA(boolean value) {
        this.removeStaticXFA = value;
    }

    public boolean isSetRemoveStaticXFA() {
        return (this.removeStaticXFA!= null);
    }

    public void unsetRemoveStaticXFA() {
        this.removeStaticXFA = null;
    }

}
