
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MetricsType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="MetricsType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pt"/>
 *     <enumeration value="pc"/>
 *     <enumeration value="px"/>
 *     <enumeration value="mm"/>
 *     <enumeration value="in"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MetricsType")
@XmlEnum
public enum MetricsType {

    @XmlEnumValue("pt")
    PT("pt"),
    @XmlEnumValue("pc")
    PC("pc"),
    @XmlEnumValue("px")
    PX("px"),
    @XmlEnumValue("mm")
    MM("mm"),
    @XmlEnumValue("in")
    IN("in");
    private final String value;

    MetricsType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MetricsType fromValue(String v) {
        for (MetricsType c: MetricsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
