
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OcrLanguageType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="OcrLanguageType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="eng"/>
 *     <enumeration value="deu"/>
 *     <enumeration value="fra"/>
 *     <enumeration value="ita"/>
 *     <enumeration value="spa"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OcrLanguageType")
@XmlEnum
public enum OcrLanguageType {

    @XmlEnumValue("eng")
    ENG("eng"),
    @XmlEnumValue("deu")
    DEU("deu"),
    @XmlEnumValue("fra")
    FRA("fra"),
    @XmlEnumValue("ita")
    ITA("ita"),
    @XmlEnumValue("spa")
    SPA("spa");
    private final String value;

    OcrLanguageType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static OcrLanguageType fromValue(String v) {
        for (OcrLanguageType c: OcrLanguageType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
