
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OcrOutputType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="OcrOutputType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="text"/>
 *     <enumeration value="hocr"/>
 *     <enumeration value="pdf"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OcrOutputType")
@XmlEnum
public enum OcrOutputType {

    @XmlEnumValue("text")
    TEXT("text"),
    @XmlEnumValue("hocr")
    HOCR("hocr"),
    @XmlEnumValue("pdf")
    PDF("pdf");
    private final String value;

    OcrOutputType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static OcrOutputType fromValue(String v) {
        for (OcrOutputType c: OcrOutputType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
