
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p327152_="https://jakarta.ee/xml/ns/jaxb" xmlns:p898759_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The "OCR" web service can be used to run character recognition in PDF documents or images.&#13;
 *                     If recognition is run on images, they will be converted to PDF documents. More specifically, a page will be generated for each image in the PDF document, with this page containing the original image and a text layer with the recognized text.&#13;
 *                     Character recognition on PDF documents will only work with documents that do not contain text already. Normally, these will be documents that were generated by scanners and that only have an image per page in the PDF document.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for OcrType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="OcrType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="page" type="{http://schema.webpdf.de/1.0/operation}OcrPageType" minOccurs="0"/>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaType" minOccurs="0"/>
 *         <element name="optimization" type="{http://schema.webpdf.de/1.0/operation}ImageOptimizationType" minOccurs="0"/>
 *       </all>
 *       <attribute name="language" type="{http://schema.webpdf.de/1.0/operation}OcrLanguageType" default="eng" />
 *       <attribute name="outputFormat" default="pdf">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}OcrOutputType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="checkResolution" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="imageDpi" default="200">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}DpiType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="forceEachPage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="normalizePageRotation" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="failOnWarning" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="jpegQuality" default="75">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="ocrMode" type="{http://schema.webpdf.de/1.0/operation}OcrModeType" default="pageSegments" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OcrType", propOrder = {

})
public class OcrType
    implements ParameterInterface
{

    protected OcrPageType page;
    protected PdfaType pdfa;
    protected ImageOptimizationType optimization;
    @XmlAttribute(name = "language")
    protected OcrLanguageType language;
    @XmlAttribute(name = "outputFormat")
    protected OcrOutputType outputFormat;
    @XmlAttribute(name = "checkResolution")
    protected Boolean checkResolution;
    @XmlAttribute(name = "imageDpi")
    protected Integer imageDpi;
    @XmlAttribute(name = "forceEachPage")
    protected Boolean forceEachPage;
    @XmlAttribute(name = "normalizePageRotation")
    protected Boolean normalizePageRotation;
    @XmlAttribute(name = "failOnWarning")
    protected Boolean failOnWarning;
    @XmlAttribute(name = "jpegQuality")
    protected Integer jpegQuality;
    @XmlAttribute(name = "ocrMode")
    protected OcrModeType ocrMode;

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link OcrPageType }
     *     
     */
    public OcrPageType getPage() {
        return page;
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrPageType }
     *     
     */
    public void setPage(OcrPageType value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaType }
     *     
     */
    public PdfaType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType }
     *     
     */
    public void setPdfa(PdfaType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }

    /**
     * Gets the value of the optimization property.
     * 
     * @return
     *     possible object is
     *     {@link ImageOptimizationType }
     *     
     */
    public ImageOptimizationType getOptimization() {
        return optimization;
    }

    /**
     * Sets the value of the optimization property.
     * 
     * @param value
     *     allowed object is
     *     {@link ImageOptimizationType }
     *     
     */
    public void setOptimization(ImageOptimizationType value) {
        this.optimization = value;
    }

    public boolean isSetOptimization() {
        return (this.optimization!= null);
    }

    /**
     * Gets the value of the language property.
     * 
     * @return
     *     possible object is
     *     {@link OcrLanguageType }
     *     
     */
    public OcrLanguageType getLanguage() {
        if (language == null) {
            return OcrLanguageType.ENG;
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrLanguageType }
     *     
     */
    public void setLanguage(OcrLanguageType value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }

    /**
     * Gets the value of the outputFormat property.
     * 
     * @return
     *     possible object is
     *     {@link OcrOutputType }
     *     
     */
    public OcrOutputType getOutputFormat() {
        if (outputFormat == null) {
            return OcrOutputType.PDF;
        } else {
            return outputFormat;
        }
    }

    /**
     * Sets the value of the outputFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrOutputType }
     *     
     */
    public void setOutputFormat(OcrOutputType value) {
        this.outputFormat = value;
    }

    public boolean isSetOutputFormat() {
        return (this.outputFormat!= null);
    }

    /**
     * Gets the value of the checkResolution property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCheckResolution() {
        if (checkResolution == null) {
            return true;
        } else {
            return checkResolution;
        }
    }

    /**
     * Sets the value of the checkResolution property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCheckResolution(boolean value) {
        this.checkResolution = value;
    }

    public boolean isSetCheckResolution() {
        return (this.checkResolution!= null);
    }

    public void unsetCheckResolution() {
        this.checkResolution = null;
    }

    /**
     * Gets the value of the imageDpi property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getImageDpi() {
        if (imageDpi == null) {
            return  200;
        } else {
            return imageDpi;
        }
    }

    /**
     * Sets the value of the imageDpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setImageDpi(int value) {
        this.imageDpi = value;
    }

    public boolean isSetImageDpi() {
        return (this.imageDpi!= null);
    }

    public void unsetImageDpi() {
        this.imageDpi = null;
    }

    /**
     * Gets the value of the forceEachPage property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isForceEachPage() {
        if (forceEachPage == null) {
            return false;
        } else {
            return forceEachPage;
        }
    }

    /**
     * Sets the value of the forceEachPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setForceEachPage(boolean value) {
        this.forceEachPage = value;
    }

    public boolean isSetForceEachPage() {
        return (this.forceEachPage!= null);
    }

    public void unsetForceEachPage() {
        this.forceEachPage = null;
    }

    /**
     * Gets the value of the normalizePageRotation property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isNormalizePageRotation() {
        if (normalizePageRotation == null) {
            return false;
        } else {
            return normalizePageRotation;
        }
    }

    /**
     * Sets the value of the normalizePageRotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setNormalizePageRotation(boolean value) {
        this.normalizePageRotation = value;
    }

    public boolean isSetNormalizePageRotation() {
        return (this.normalizePageRotation!= null);
    }

    public void unsetNormalizePageRotation() {
        this.normalizePageRotation = null;
    }

    /**
     * Gets the value of the failOnWarning property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFailOnWarning() {
        if (failOnWarning == null) {
            return false;
        } else {
            return failOnWarning;
        }
    }

    /**
     * Sets the value of the failOnWarning property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setFailOnWarning(boolean value) {
        this.failOnWarning = value;
    }

    public boolean isSetFailOnWarning() {
        return (this.failOnWarning!= null);
    }

    public void unsetFailOnWarning() {
        this.failOnWarning = null;
    }

    /**
     * Gets the value of the jpegQuality property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getJpegQuality() {
        if (jpegQuality == null) {
            return  75;
        } else {
            return jpegQuality;
        }
    }

    /**
     * Sets the value of the jpegQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setJpegQuality(int value) {
        this.jpegQuality = value;
    }

    public boolean isSetJpegQuality() {
        return (this.jpegQuality!= null);
    }

    public void unsetJpegQuality() {
        this.jpegQuality = null;
    }

    /**
     * Gets the value of the ocrMode property.
     * 
     * @return
     *     possible object is
     *     {@link OcrModeType }
     *     
     */
    public OcrModeType getOcrMode() {
        if (ocrMode == null) {
            return OcrModeType.PAGE_SEGMENTS;
        } else {
            return ocrMode;
        }
    }

    /**
     * Sets the value of the ocrMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrModeType }
     *     
     */
    public void setOcrMode(OcrModeType value) {
        this.ocrMode = value;
    }

    public boolean isSetOcrMode() {
        return (this.ocrMode!= null);
    }

}
