
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for operation element declaration.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <element name="operation">
 *   <complexType>
 *     <complexContent>
 *       <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *         <sequence>
 *           <element name="billing" type="{http://schema.webpdf.de/1.0/operation}BillingType" minOccurs="0"/>
 *           <element name="password" type="{http://schema.webpdf.de/1.0/operation}PdfPasswordType" minOccurs="0"/>
 *           <element name="settings" type="{http://schema.webpdf.de/1.0/operation}SettingsType" minOccurs="0"/>
 *           <choice>
 *             <element name="barcode" type="{http://schema.webpdf.de/1.0/operation}BarcodeType"/>
 *             <element name="converter" type="{http://schema.webpdf.de/1.0/operation}ConverterType"/>
 *             <element name="ocr" type="{http://schema.webpdf.de/1.0/operation}OcrType"/>
 *             <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaType"/>
 *             <element name="signature" type="{http://schema.webpdf.de/1.0/operation}SignatureType"/>
 *             <choice maxOccurs="unbounded">
 *               <element name="annotation" type="{http://schema.webpdf.de/1.0/operation}AnnotationType"/>
 *               <element name="attachment" type="{http://schema.webpdf.de/1.0/operation}AttachmentType"/>
 *               <element name="delete" type="{http://schema.webpdf.de/1.0/operation}DeleteType"/>
 *               <element name="description" type="{http://schema.webpdf.de/1.0/operation}DescriptionType"/>
 *               <element name="extraction" type="{http://schema.webpdf.de/1.0/operation}ExtractionType"/>
 *               <element name="forms" type="{http://schema.webpdf.de/1.0/operation}FormsType"/>
 *               <element name="image" type="{http://schema.webpdf.de/1.0/operation}ImageType"/>
 *               <element name="merge" type="{http://schema.webpdf.de/1.0/operation}MergeType"/>
 *               <element name="options" type="{http://schema.webpdf.de/1.0/operation}OptionsType"/>
 *               <element name="print" type="{http://schema.webpdf.de/1.0/operation}PrintType"/>
 *               <element name="rotate" type="{http://schema.webpdf.de/1.0/operation}RotateType"/>
 *               <element name="security" type="{http://schema.webpdf.de/1.0/operation}SecurityType"/>
 *               <element name="split" type="{http://schema.webpdf.de/1.0/operation}SplitType"/>
 *               <element name="watermark" type="{http://schema.webpdf.de/1.0/operation}WatermarkType"/>
 *               <element name="xmp" type="{http://schema.webpdf.de/1.0/operation}XmpType"/>
 *               <element name="move" type="{http://schema.webpdf.de/1.0/operation}MoveType"/>
 *               <element name="outline" type="{http://schema.webpdf.de/1.0/operation}OutlineType"/>
 *               <element name="redact" type="{http://schema.webpdf.de/1.0/operation}RedactType"/>
 *               <element name="portfolio" type="{http://schema.webpdf.de/1.0/operation}PortfolioType"/>
 *               <element name="scale" type="{http://schema.webpdf.de/1.0/operation}ScaleType"/>
 *               <element name="compress" type="{http://schema.webpdf.de/1.0/operation}CompressType"/>
 *               <element name="transcribe" type="{http://schema.webpdf.de/1.0/operation}TranscribeType"/>
 *             </choice>
 *             <element name="urlconverter" type="{http://schema.webpdf.de/1.0/operation}UrlConverterType"/>
 *           </choice>
 *         </sequence>
 *       </restriction>
 *     </complexContent>
 *   </complexType>
 * </element>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "billing",
    "password",
    "settings",
    "barcode",
    "converter",
    "ocr",
    "pdfa",
    "signature",
    "toolbox",
    "urlconverter"
})
@XmlRootElement(name = "operation")
public class OperationData {

    protected BillingType billing;
    protected PdfPasswordType password;
    protected SettingsType settings;
    protected BarcodeType barcode;
    protected ConverterType converter;
    protected OcrType ocr;
    protected PdfaType pdfa;
    protected SignatureType signature;
    @XmlElements({
        @XmlElement(name = "annotation", type = AnnotationType.class),
        @XmlElement(name = "attachment", type = AttachmentType.class),
        @XmlElement(name = "delete", type = DeleteType.class),
        @XmlElement(name = "description", type = DescriptionType.class),
        @XmlElement(name = "extraction", type = ExtractionType.class),
        @XmlElement(name = "forms", type = FormsType.class),
        @XmlElement(name = "image", type = ImageType.class),
        @XmlElement(name = "merge", type = MergeType.class),
        @XmlElement(name = "options", type = OptionsType.class),
        @XmlElement(name = "print", type = PrintType.class),
        @XmlElement(name = "rotate", type = RotateType.class),
        @XmlElement(name = "security", type = SecurityType.class),
        @XmlElement(name = "split", type = SplitType.class),
        @XmlElement(name = "watermark", type = WatermarkType.class),
        @XmlElement(name = "xmp", type = XmpType.class),
        @XmlElement(name = "move", type = MoveType.class),
        @XmlElement(name = "outline", type = OutlineType.class),
        @XmlElement(name = "redact", type = RedactType.class),
        @XmlElement(name = "portfolio", type = PortfolioType.class),
        @XmlElement(name = "scale", type = ScaleType.class),
        @XmlElement(name = "compress", type = CompressType.class),
        @XmlElement(name = "transcribe", type = TranscribeType.class)
    })
    protected List<BaseToolboxType> toolbox;
    protected UrlConverterType urlconverter;

    /**
     * Gets the value of the billing property.
     * 
     * @return
     *     possible object is
     *     {@link BillingType }
     *     
     */
    public BillingType getBilling() {
        return billing;
    }

    /**
     * Sets the value of the billing property.
     * 
     * @param value
     *     allowed object is
     *     {@link BillingType }
     *     
     */
    public void setBilling(BillingType value) {
        this.billing = value;
    }

    public boolean isSetBilling() {
        return (this.billing!= null);
    }

    /**
     * Gets the value of the password property.
     * 
     * @return
     *     possible object is
     *     {@link PdfPasswordType }
     *     
     */
    public PdfPasswordType getPassword() {
        return password;
    }

    /**
     * Sets the value of the password property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfPasswordType }
     *     
     */
    public void setPassword(PdfPasswordType value) {
        this.password = value;
    }

    public boolean isSetPassword() {
        return (this.password!= null);
    }

    /**
     * Gets the value of the settings property.
     * 
     * @return
     *     possible object is
     *     {@link SettingsType }
     *     
     */
    public SettingsType getSettings() {
        return settings;
    }

    /**
     * Sets the value of the settings property.
     * 
     * @param value
     *     allowed object is
     *     {@link SettingsType }
     *     
     */
    public void setSettings(SettingsType value) {
        this.settings = value;
    }

    public boolean isSetSettings() {
        return (this.settings!= null);
    }

    /**
     * Gets the value of the barcode property.
     * 
     * @return
     *     possible object is
     *     {@link BarcodeType }
     *     
     */
    public BarcodeType getBarcode() {
        return barcode;
    }

    /**
     * Sets the value of the barcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link BarcodeType }
     *     
     */
    public void setBarcode(BarcodeType value) {
        this.barcode = value;
    }

    public boolean isSetBarcode() {
        return (this.barcode!= null);
    }

    /**
     * Gets the value of the converter property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterType }
     *     
     */
    public ConverterType getConverter() {
        return converter;
    }

    /**
     * Sets the value of the converter property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterType }
     *     
     */
    public void setConverter(ConverterType value) {
        this.converter = value;
    }

    public boolean isSetConverter() {
        return (this.converter!= null);
    }

    /**
     * Gets the value of the ocr property.
     * 
     * @return
     *     possible object is
     *     {@link OcrType }
     *     
     */
    public OcrType getOcr() {
        return ocr;
    }

    /**
     * Sets the value of the ocr property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrType }
     *     
     */
    public void setOcr(OcrType value) {
        this.ocr = value;
    }

    public boolean isSetOcr() {
        return (this.ocr!= null);
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaType }
     *     
     */
    public PdfaType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType }
     *     
     */
    public void setPdfa(PdfaType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    public boolean isSetSignature() {
        return (this.signature!= null);
    }

    /**
     * Gets the value of the toolbox property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the toolbox property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getToolbox().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AnnotationType }
     * {@link AttachmentType }
     * {@link CompressType }
     * {@link DeleteType }
     * {@link DescriptionType }
     * {@link ExtractionType }
     * {@link FormsType }
     * {@link ImageType }
     * {@link MergeType }
     * {@link MoveType }
     * {@link OptionsType }
     * {@link OutlineType }
     * {@link PortfolioType }
     * {@link PrintType }
     * {@link RedactType }
     * {@link RotateType }
     * {@link ScaleType }
     * {@link SecurityType }
     * {@link SplitType }
     * {@link TranscribeType }
     * {@link WatermarkType }
     * {@link XmpType }
     * 
     * 
     * @return
     *     The value of the toolbox property.
     */
    public List<BaseToolboxType> getToolbox() {
        if (toolbox == null) {
            toolbox = new ArrayList<>();
        }
        return this.toolbox;
    }

    public boolean isSetToolbox() {
        return ((this.toolbox!= null)&&(!this.toolbox.isEmpty()));
    }

    public void unsetToolbox() {
        this.toolbox = null;
    }

    /**
     * Gets the value of the urlconverter property.
     * 
     * @return
     *     possible object is
     *     {@link UrlConverterType }
     *     
     */
    public UrlConverterType getUrlconverter() {
        return urlconverter;
    }

    /**
     * Sets the value of the urlconverter property.
     * 
     * @param value
     *     allowed object is
     *     {@link UrlConverterType }
     *     
     */
    public void setUrlconverter(UrlConverterType value) {
        this.urlconverter = value;
    }

    public boolean isSetUrlconverter() {
        return (this.urlconverter!= null);
    }

}
