
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OptimizationIntensityType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="OptimizationIntensityType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="off"/>
 *     <enumeration value="value"/>
 *     <enumeration value="low"/>
 *     <enumeration value="medium"/>
 *     <enumeration value="high"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OptimizationIntensityType")
@XmlEnum
public enum OptimizationIntensityType {

    @XmlEnumValue("off")
    OFF("off"),
    @XmlEnumValue("value")
    VALUE("value"),
    @XmlEnumValue("low")
    LOW("low"),
    @XmlEnumValue("medium")
    MEDIUM("medium"),
    @XmlEnumValue("high")
    HIGH("high");
    private final String value;

    OptimizationIntensityType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static OptimizationIntensityType fromValue(String v) {
        for (OptimizationIntensityType c: OptimizationIntensityType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
