
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PageLayoutType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PageLayoutType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="singlePage"/>
 *     <enumeration value="singlePageContinous"/>
 *     <enumeration value="twoPages"/>
 *     <enumeration value="twoPagesRight"/>
 *     <enumeration value="twoPagesContinous"/>
 *     <enumeration value="twoPagesContinousRight"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageLayoutType")
@XmlEnum
public enum PageLayoutType {

    @XmlEnumValue("singlePage")
    SINGLE_PAGE("singlePage"),
    @XmlEnumValue("singlePageContinous")
    SINGLE_PAGE_CONTINOUS("singlePageContinous"),
    @XmlEnumValue("twoPages")
    TWO_PAGES("twoPages"),
    @XmlEnumValue("twoPagesRight")
    TWO_PAGES_RIGHT("twoPagesRight"),
    @XmlEnumValue("twoPagesContinous")
    TWO_PAGES_CONTINOUS("twoPagesContinous"),
    @XmlEnumValue("twoPagesContinousRight")
    TWO_PAGES_CONTINOUS_RIGHT("twoPagesContinousRight");
    private final String value;

    PageLayoutType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PageLayoutType fromValue(String v) {
        for (PageLayoutType c: PageLayoutType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
